#include <windows.h>
#include <winsock.h>
#include <stdlib.h>
#include <fstream.h>
#include <process.h>
#include <stdio.h>
#include <assert.h>
#include <conio.h>

#define NUMBER_OF_THREADS 5
#define NUMBER_OF_COMMON_PORTS 32

int SocketStuff(void);
void scan(LPVOID SockThread);
void PortScan(char * address);


static SOCKET			sock[NUMBER_OF_THREADS];
static sockaddr_in		addr[NUMBER_OF_THREADS];
static unsigned int		timeout;
static unsigned int		nr_of_ips;
static unsigned int		nr_of_ports; 
static unsigned int		end_port;
static unsigned int		start_port;
static BOOL				use_dynamic;
static BOOL				scan_only_known;


static unsigned int common_ports[NUMBER_OF_COMMON_PORTS] = 
{
 7,    9,  11,  13,  15,  21,  23,  25,  37,  42,
 43,  57,  69,  77,  79,  80,  81,  87,  95,  99,
 110, 119, 139, 142, 143, 144, 161, 512, 513, 514,
 520, 6000 
};

typedef struct
{     
     int  port ;
     int  to_ret ;
	 int  sock_nr;
     BOOL clear ;
}PRMS, *PPARAMS ;

PRMS sock_thread[NUMBER_OF_THREADS];

void help(void)
{
	printf(	"\nUsage: portscn [options] [hosts...]\n\n"
			
			"Options:\n\n"
			
			"-t \t\t-t followed by a number (-t40 is default if none specified)\n"
			"   \t\tspecifies the number of milliseconds to delay the scanning.\n"
			"   \t\tSetting this high will make a safe scanning without no lost\n"
			"   \t\tports. But a long delay takes long time\n\n"
			
			"-f \t\tSpecifies how many ip's that should be scanned at the host\n"
			"   \t\t(-f1 is default)\n\n"
			
			"-s \t\tTell the portscanner to use dynamic delay (usually slower\n"
			"   \t\tbut is you know what you are doing it can be faster) Read\n"
			"   \t\tsourcecode for more info\n\n"
			
			"-b \t\t-b followed by a number specifies which port to start scan\n\n"
			
			"-e \t\t-e followed by a number tells which port to end the scan.\n\n"
			
			"-k \t\tTell the scanner that only the usual ports should be scanned\n\n"
			
			"-a \t\t-a followed by the address to be scanned (not optional)\n\n"
						
			"TIP! You can scan several addresses whithin the same scanning session by"
			"specify several addresses with the -a option.\n"
			"\nExample: portscn -t50 -f4 -k -awww.firsthost.com -f2 -asecondhost.com\n\n"
			"The above example will scan 4 ip's at www.firsthost.com and 2 ip's at "
			"secondhost.com. Read the sourcecode for more information\n\n");
}


int main(int argc, char *argv[], char *env[])
{
	int i = 1;
	char *address = NULL;
	DWORD take_time = GetTickCount();


	printf("\n"
		   " |\\                                  /|\n"
		   "||   Fast Improved PortScanner v0.9   ||\n"
		   "|:   Copyright: protected under GPL   :|\n"
		   "||   Author: James Dickson            ||\n"
		   "|:   Contact: james@linux.nu          :|\n"
		   "||   Created: Year 2000               ||\n"
		   " |/                                  \\|\n"
		   "\n");

	if(SocketStuff() != 0) 
	{ 
		printf("ERROR: Could not initialize socket");
		help();
		exit(0);
		
	}



	//default before parsing

	timeout =			40;
	nr_of_ips =			1;
	start_port =		0;
	end_port =			0;
	use_dynamic =		FALSE;
	scan_only_known =	TRUE;

	//parse arguments

	while(i < argc)
	{	
		if(argv[i][0] == '-')
		{
			if(argv[i][1] == 't')
			{
				char temp[15];
				unsigned int k=2;

				while(k < strlen(argv[i]))
				{
					temp[k-2] = argv[i][k];
					k++;
				}

				timeout = atoi(temp);
			}
			else if(argv[i][1] == 'f')
			{
				char temp[15];
				unsigned int k=2;

				while(k < strlen(argv[i]))
				{
					temp[k-2] = argv[i][k];
					k++;
				}

				nr_of_ips = atoi(temp);

			}
			else if(argv[i][1] == 'b')
			{
				char temp[15];
				unsigned int k=2;

				while(k < strlen(argv[i]))
				{
					temp[k-2] = argv[i][k];
					k++;
				}

				scan_only_known =	FALSE;

				start_port = atoi(temp);

			}
			else if(argv[i][1] == 'e')
			{
				char temp[15];
				unsigned int k=2;

				while(k < strlen(argv[i]))
				{
					temp[k-2] = argv[i][k];
					k++;
				}

				scan_only_known =	FALSE;

				end_port = atoi(temp);

			}
			else if(argv[i][1] == 's')
			{
				use_dynamic = TRUE;
			}
			else if(argv[i][1] == 'k')
			{
				scan_only_known =	TRUE;
			}
			else if(argv[i][1] == 'a')
			{				
				unsigned int scanned_ips = 0;

				while(scanned_ips < nr_of_ips)
				{
					static char last_host[260];

					address = (char *) malloc(strlen(argv[i]));	
					

					if(address == NULL)
					{
						printf("Could not allocate memory!\n");
						exit(0);
					}

					if(scanned_ips == 0)
					{
						unsigned int c=2;

						while(c < strlen(argv[i]))
						{
							address[c-2] = last_host[c-2] = argv[i][c];
							address[c-1] = last_host[c-1] = 0;
							c++;
						}

						
					}
					else
					{
						must_be_ip:

						 if(isdigit(last_host[0]))
						 {
							 unsigned int ind=0,incrint = 0;;
							 unsigned int c = 0;
							 unsigned int pnts=0;
							 char lastch[4],again[4];

							 							 							
							 while(c < strlen(last_host))
							 {
								address[c] = last_host[c];
								address[c+1] = 0;
								c++;
							 } 


							 while(address[ind] != '\0' && pnts < 3)
							 {
								if(address[ind] == '.')
								{
									pnts++;
								}
								ind++;
							 }

							 pnts = 0;

							 while(address[ind] != '\0')
							 {

								lastch[pnts] = address[ind];
								lastch[pnts +1] = '\0';
								address[ind] = '\0';
								ind++;
								pnts++;
							 }


							incrint = atoi(lastch);
							incrint++;
							sprintf(again, "%d", incrint); 
							strcat(address, again);
							strcpy(last_host, address);
						

						 }
						 else
						 {
							struct				hostent *H2;
							in_addr				tempsint;

							H2=gethostbyname(last_host); 
						
							if(H2 == NULL) 
							{

								printf("Could not gethostbyname"); 
								exit(0);
							}

							tempsint.s_addr =*((unsigned long *) H2->h_addr_list[0]);						

							strcpy(address, inet_ntoa(tempsint));
							strcpy(last_host, address);

							goto must_be_ip; // Yeah, this is ugly

						 }
					}

					PortScan(address);
				
					free(address);
					printf("\n");

					scanned_ips++;
				}
				
			}
			else
			{
				help();
				exit(0);

			}

			

		}
		else
		{
			help();
			exit(0);
		}

		i++;
	}

   
	if(argc > 1)
	{
		DWORD end_time = GetTickCount() -take_time;

		printf("\n\nScanning finished in %d.%d seconds\n", 
			(end_time / 1000), (end_time % 1000));
	}
	else
	{
		help();
	}

	
	WSACleanup();

	return 0;
}


int SocketStuff(void)
{
	WORD		wVersionRequested;
	WSADATA		wsaData;	  
	int			err;

	wVersionRequested = MAKEWORD(1, 0);

	err = WSAStartup (wVersionRequested, &wsaData);
	
	if ( err != 0 ) 
	{
	
		WSACleanup();
		return WSAGetLastError();
	}


	return 0;

}

void PortScan(char *address)
{
	auto struct				hostent *H;
	auto BOOL all_not_clear = TRUE;
	auto DWORD time_to_kill;
	auto DWORD time_is_not_out=0;
	auto unsigned int countdown;
	auto unsigned int nr_of_threads = NUMBER_OF_THREADS;


	for(int x = 0; x < NUMBER_OF_THREADS; x++)
	{
		if(isdigit(address[0]))
		{
						
			addr[x].sin_addr.s_addr = inet_addr(address);

		}
		else
		{	
			
			H=gethostbyname(address);
			
			if(H == NULL)
			{	
				printf("ERROR: gethostbyname() did not work");
				
				return;
			}
			

			addr[x].sin_addr.s_addr =*((unsigned long *) H->h_addr);;

		}				

		addr[x].sin_family = PF_INET;

	}

			

		if(scan_only_known)
		{
			countdown = 0;
			end_port = 31;
			printf("\nListening ports at: %s (common services scanned) \n\n", address);
		}
		else
		{
			countdown = start_port;
			printf("\nListening ports between %d and %d at: %s \n\n", start_port, end_port, address);
		}

				
		do
		{

			if((end_port - countdown) < NUMBER_OF_THREADS) nr_of_threads = end_port - countdown +1;

			for(unsigned int i= 0; i < nr_of_threads; i++)
			{
				if(scan_only_known)
				{
					sock_thread[i].port = common_ports[countdown +i];
				}
				else
				{
					sock_thread[i].port = countdown +i;
				}

				sock_thread[i].clear = FALSE;
				sock_thread[i].sock_nr = i;
				sock_thread[i].to_ret = 0;

				_beginthread (scan, 0, &sock_thread[i]);
				_sleep(10);
				//printf("thread %d port %d\n", i, sock_thread[i].port);
			}
			
			if(use_dynamic)
			{

				time_to_kill = GetTickCount();

				all_not_clear = TRUE;

				while(all_not_clear == TRUE)
				{
					for(int j = 0; j < NUMBER_OF_THREADS; j++)
					{									
						if(sock_thread[j].clear == FALSE) 
						{
							all_not_clear = TRUE;
							break;
						}
					}
					if(( GetTickCount() - time_to_kill) >= timeout)
					{
						
						WSACancelBlockingCall ();
						//_sleep(10);
						break;
					}
				}			
			}
			else
			{
				_sleep(timeout);
				WSACancelBlockingCall ();
				
			}

			countdown += nr_of_threads ;
														
		}
		while((countdown <= end_port ) && !kbhit());



}

void scan(LPVOID SockThread)
{

	PPARAMS SockParams ;
	int auto rets;

    SockParams = (PPARAMS) SockThread; 

	sock[SockParams->sock_nr] = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);		
			
  	
	if (sock[SockParams->sock_nr] == SOCKET_ERROR) 
	{	

		SockParams->clear = TRUE;
			
		return;
	}
	else
	{

		addr[SockParams->sock_nr].sin_port = htons(SockParams->port);

		rets = connect( sock[SockParams->sock_nr],
						(struct sockaddr *) &addr[SockParams->sock_nr], 
						sizeof(sockaddr_in));

		closesocket(sock[SockParams->sock_nr]);		    

		if (rets == SOCKET_ERROR) 
		{

		
			SockParams->clear = TRUE;        
			return;
		}
		else
		{
			printf("%d ", SockParams->port);
			SockParams->clear = TRUE;
		}
	}
		
	return;	
}	 