/************************************************************************\

               CATTscanner 0.61 - Atlanta.CON Release

   by Optyx <optyx@uberhax0r.net>     Uberhax0r Communications (c) 2000

       CATTscanner home page: http://www.uberhax0r.net/cattscanner

 cattscan.c 03/18/00                                    CATTscanner Core
\***********************************************************************/

#include <stdio.h>

#define VERSION "CATTscanner 0.61 Atlanta.CON Release"

char exhosts[65025][15];
char hosts[65025][15];
char datadir[16], conffile[64]="cattscan.conf";
int revdns=0;
int startport=0, endport=0;
int rpcmap=0,nfsmap=0,nbtmap=0;
int smtpver=0,ftpver=0,popver=0,imapver=0;
int udp=0,tcp=0,ident=0,timeout=3;
int threads=0;

int main(int argc, char *argv[]) {

   int i, k;
   char compare[16], value[16], input[64];
   FILE *conf;

   if(argc>1) {

      strcpy(conffile, argv[1]);

   }
   
   if((conf=fopen(conffile, "r")) == NULL) {
                                   
      printf("creating configuration file: %s\n", conffile);
              
   }
   else {
   
   fgets(input, 64, conf);
   
   while(!feof(conf)) {

      i=0;
      while(input[i]!='=') {
      
         compare[i]=input[i];
         i++;

      }

      compare[i]='\0';
      i++;
      k=0;
       
      while(input[i]!='\0') {

         value[k]=input[i];
         k++;
         i++;

      }

      
      value[k-1]='\0';
                     
      if(!strcasecmp(compare, "outdir")) {
                                   
          strncpy(datadir, value, 16);
                                   
      }
      
      if(!strcasecmp(compare, "revdns")) {
                                   
          if(atoi(value)) {
                          
             revdns=1;
                     
          }
          else {
               
             revdns=0;
                     
          }
          
      }
      
      if(!strcasecmp(compare, "startport")) {
                                   
          startport=atoi(value);   
                                   
      }
      
      if(!strcasecmp(compare, "endport")) {
                                   
          endport=atoi(value);
                             
      }
      
      if(!strcasecmp(compare, "rpcmap")) {
                                   
          if(atoi(value)) {
                          
             rpcmap=1;
                     
          }
          else {
               
             rpcmap=0;
                     
          }
          
      }
      
      if(!strcasecmp(compare, "nfsmap")) {
                                   
          if(atoi(value)) {
                          
             nfsmap=1;
                     
          }
          else {
               
             nfsmap=0;
                     
          }
          
      }
      
      if(!strcasecmp(compare, "nbtmap")) {
                                   
          if(atoi(value)) {
                          
             nbtmap=1;
                     
          }
          else {
               
             nbtmap=0;
                     
          }
          
      }
      
      if(!strcasecmp(compare, "smtpver")) {
                                   
          if(atoi(value)) {
                          
             smtpver=1;
                      
          }
          else {
               
             smtpver=0;
                      
          }
          
      }
      
      if(!strcasecmp(compare, "ftpver")) {
                                   
          if(atoi(value)) {
                          
             ftpver=1;
                                  
          }           
          else {
               
             ftpver=0;             
                                   
          }           
                      
      }   
          
      if(!strcasecmp(compare, "imapver")) {
                                   
          if(atoi(value)) {
                          
             imapver=1;            
                                   
          }           
          else {
               
             imapver=0;
                                   
          }           
                      
      }   
          
      if(!strcasecmp(compare, "popver")) {
                                   
          if(atoi(value)) {
                          
             popver=1;             
                                   
          }           
          else {
               
             popver=0;             
                                   
          }           
                      
      }   
          
      if(!strcasecmp(compare, "host")) {
                                   
         i=0;

         while(strcmp(hosts[i], "")) {

            i++; 

         }

         strcpy(hosts[i], value);
                            
      }
      
      if(!strcasecmp(compare, "exhost")) {
                                   
         i=0;

         while(strcmp(exhosts[i], "")) {

            i++;

         }

         strcpy(exhosts[i], value);                            

      }
      
      if(!strcasecmp(compare, "threads")) {
                                   
          if(!strcasecmp(value, "max"))
            threads=-1;
          else
             threads=atoi(value);
                                
      }
      
      if(!strcasecmp(compare, "scantype")) {
                                   
          if(!strcasecmp(value, "udp")) {
                                   
             udp=1;     
                        
          }
          else {
               
             tcp=1;
                  
          }
          
      }
      
      if(!strcasecmp(compare, "ident")) {
                                   
          if(atoi(value)) {
                          
             ident=1;
                    
          }
          else
          {
          
             ident=0;
                    
          }
      }
      
      if(!strcasecmp(compare, "timeout")) {
                                   
          timeout=atoi(value);
                             
      }
      
      fgets(input, 64, conf);
   }

   fclose(conf);

   }

   while(display())
      ;

   return 0;
}

int display() {
   
   char c;

   printf("\n\ncattconf - %s\n\n", VERSION);
   printf("1 - generic options\n");
   printf("2 - add hosts or exclude hosts\n");
   printf("3 - remove hosts or exclude hosts\n");
   printf("4 - set portscan options\n");
   printf("5 - set mapping options\n");
   printf("6 - set version query options\n");
   printf("9 - quit and save\n");
   printf("0 - quit with no save\n");
   printf(": ");

   c=getc(stdin);
   getc(stdin);

   switch(c) {
    case '0':
              return 0;

    case '9':
              return saveconf();

    case '1':
              connoptmenu();
              break; 

    case '2':
              addhostsmenu();
              break; 

    case '3':
              rmvhostsmenu();
              break; 

    case '4':
              portscanoptmenu();
              break; 

    case '5':
              mapoptmenu();
              break; 

    case '6':
              veroptmenu();
              break; 

    default :
              printf("\ninvalid input\n");
              break;
   }

   return 1;
}

connoptmenu() {

   int i;
   char c;
   
   for(;;) {
      printf("\n\ngeneric options\n");
      printf("1 - threads value %d\n", threads);
      printf("2 - timeout value %d\n", timeout);
      printf("3 - reverse dns is %s\n", (revdns)?"on":"off");
      printf("0 - back to main menu\n");
      printf(": ");

      c=getc(stdin);
      getc(stdin);

      switch(c) {

         case '0':
                   return;

         case '1':
                   do
                     i=getnum("threads", threads);
                   while(i==-1);
                   
                   threads=i;
                   break;                  

         case '2':
                   do
                     i=getnum("timeout", timeout);
                   while(i==-1);

                   timeout=i;
                   break;
         case '3':
                   revdns=switchon(revdns);
                   break;
         default :
                   printf("\ninvalid input\n");
                   break;
      }

   }

}

addhostsmenu() {
   char c;

   for(;;) {
      printf("\n\nadd hosts\n");
      printf("1 - add hosts to scan\n");
      printf("2 - add exclude hosts\n");
      printf("0 - back to main menu\n");
      printf(": ");

      c=getc(stdin);
      getc(stdin);

      switch(c) {

         case '0':
                   return;

         case '1':
                   while(addhosts(1))
                      ;

                   break;
 
         case '2':
                   while(addhosts(0))
                      ; 

                   break;
 
         default :
                   printf("\ninvalid input\n");
                   break;
      }
 
   }

}

rmvhostsmenu() {

   int i;
   char c;

   for(;;) {

      printf("\n\nremove hosts\n");
      printf("1 - remove scan hosts\n");
      printf("2 - remove exclude hosts\n");
      printf("0 - back to main menu\n");
      printf(": ");
      
      c=getc(stdin);
      getc(stdin);

      switch(c) {
  
         case '0':
                   return;

         case '1':
                   while(removehosts(1))
                      ;
                   break;
         case '2':
                   while(removehosts(0))
                      ;
                   break;
         default :
                   printf("invalid input\n");
                   break;

      }     

   }

}

portscanoptmenu() {

   int i;
   char c;

   for(;;) {

      printf("\n\nportscan options\n");
      printf("1 - starting port value %d\n", startport);
      printf("2 - ending port value %d\n", endport);
      printf("3 - TCP scan is %s\n", (tcp)?"on":"off");
      printf("4 - UDP scan is broken currently\n");
      printf("5 - check for service ownership is %s\n", (ident)?"on":"off");
      printf("0 - back to main menu\n");
      printf(": ");

      c = getc(stdin);
      getc(stdin);

      switch(c) {

         case '0':
                    return;
    
         case '1':
                    do
                       i = getnum("starting port", startport);
                    while(i==-1);
                    startport=i;

                    break;

         case '2':
                    do
                       i = getnum("ending port", endport);
                    while(i==-1);
                    endport=i;

                    break;

         case '3':
                    tcp = switchon(tcp);
                    break; 

         case '4':
                    printf("B-R-O-K-E-N\n");
                    break;

         case '5':
                    ident=switchon(ident);
                    break;

         default :
                    printf("invalid input\n");
                    break;
      }
   }
}

mapoptmenu() {

   char c;

   for(;;) {

      printf("\n\nmapping options\n");
      printf("1 - RPC mapping is %s\n", (rpcmap)?"on":"off");
      printf("2 - NFS mapping is %s\n", (nfsmap)?"on":"off");
      printf("3 - Netbios mapping is %s\n", (nbtmap)?"on":"off");
      printf("0 - back to main menu\n");
      printf(": ");
    
      c=getc(stdin);
      getc(stdin);

      switch(c) {
         case '0':
                   return;

         case '1':
                   rpcmap=switchon(rpcmap);
                   break;
         case '2': 
                   nfsmap=switchon(nfsmap);
                   break;

         case '3':
                   nbtmap=switchon(nbtmap);
                   break;

         default :
                   printf("invalid input\n");
                   break;
      } 
   }
}

veroptmenu() {
 
   int i;
   char c;
 
   for(;;) {
 
      printf("\n\nversion query options\n");
      printf("1 - FTP version query is %s\n", (ftpver)?"on":"off");
      printf("2 - SMTP version query is %s\n", (smtpver)?"on":"off");
      printf("3 - POP3 version query is %s\n", (popver)?"on":"off");
      printf("4 - IMAP version query is %s\n", (imapver)?"on":"off");
      printf("0 - back to main menu\n");
      printf(": ");
 
      c=getc(stdin);
      getc(stdin);
 
      switch(c) {
         case '0':
                   return;
 
         case '1':
                   ftpver=switchon(ftpver);
                   break;
 
         case '2':
                   smtpver=switchon(smtpver);
                   break;
 
         case '3':
                   popver=switchon(popver);
                   break;

         case '4':
                   imapver=switchon(imapver);
                   break;
         default :
                   printf("invalid input\n");
                   break;
      }
   }
}

int saveconf() {

   int i;
   FILE *out;

   if((out=fopen(conffile, "w")) == NULL) {
      printf("error in writing to %s\n", conffile);
      return 1;
   }

   i=0;

   while(strcmp(hosts[i], "")) {
      fprintf(out, "host=%s\n", hosts[i]);
      i++;
   }

   i=0;

   while(strcmp(exhosts[i], "")) {
      fprintf(out, "exhost=%s\n", exhosts[i]);
      i++;
   }

   fprintf(out, "threads=%d\n", threads);
   fprintf(out, "timeout=%d\n", timeout);
   fprintf(out, "startport=%d\n", startport);
   fprintf(out, "endport=%d\n", endport);

   if(tcp)
      fprintf(out, "scantype=tcp\n");

   if(udp)
      fprintf(out, "scantype=udp\n");

   fprintf(out, "ident=%d\n", ident);
   fprintf(out, "nfsmap=%d\n", nfsmap);
   fprintf(out, "nbtmap=%d\n", nbtmap);
   fprintf(out, "rpcmap=%d\n", rpcmap);
   fprintf(out, "ftpver=%d\n", ftpver);
   fprintf(out, "smtpver=%d\n", smtpver);
   fprintf(out, "popver=%d\n", popver);
   fprintf(out, "imapver=%d\n", imapver);

   fclose(out);

   printf("config file %s saved\n", conffile);

   return 0;      
}

int getnum(char prompt[], int val) {

   char input[80];

    printf("enter numerical value for %s\n", prompt);
    printf("[%d]: ", val);

    fgets(input, 80, stdin);
    input[strlen(input) - 1] = '\0';

    if(!strcmp(input, ""))
       return val;

    if(atoi(input)==0)
       return -1;

    return atoi(input);

}

int switchon(int val) {

   if(val)
      return 0; 
   else
      return 1;
}

int removehosts(int h) {

   int i=0, j;
   char input[80]="";

   if(h) {

      printf("Enter host to remove - * wildcards welcom - ");
      printf("\"list\" to list hosts\n");

   }
   else {

      printf("Enter exclude host to remove - * wildcards welcome -");
      printf("\"list\" to list exhosts\n");

   }

   printf("[done]: ");

   fgets(input, 80, stdin);
   printf("\n");
   input[strlen(input)-1]='\0';
 
   if((!strcmp(input, "")) || (!strcasecmp(input, "done")))
      return 0;

   if(!strcasecmp(input, "list")) {
      listhosts(h);
      return 1;
   }

   if(h) {
   
      for(i=0;strcmp(hosts[i], "");i++) {

         if(!strcmp(hosts[i], input)) {

            for(j=i;strcmp(hosts[j+1], "");j++) {
    
               strcpy(hosts[j], hosts[j+1]);
 
            }

         }

      }

   }
   else {

      for(i=0;strcmp(exhosts[i], "");i++) {

         if(!strcmp(exhosts[i], input)) {
            
            for(j=i;strcmp(exhosts[j+1], "");j++) {  
            
               strcpy(exhosts[j], exhosts[j+1]);
            
            }
         
         }
      
      }

   }
   
   return 1;  

}

int addhosts(int h) {

   int i=0;
   char input[80]="";

   if(h) {

      printf("Enter host to add - * wildcards welcome - ");
      printf("\"list\" to list hosts\n");

   }
   else {

      printf("Enter exclude host to add - * wildcards welcome - ");
      printf("\"list\" to list exhosts\n");

   }

   printf("[done]: ");
   fgets(input, 80, stdin);
   printf("\n");
   input[strlen(input)-1]='\0';

   if((!strcmp(input, "")) || (!strcasecmp(input, "done")))
      return 0;

   if(!strcasecmp(input, "list")) {
      listhosts(h);
      return 1;
   }

   if(h) {

      while(strcmp(hosts[i], "")) {

         i++;

      }

      strcpy(hosts[i], input);
      printf("Added %s to the scan hosts\n", input);

   }
   else {

      while(strcmp(exhosts[i], "")) {

         i++;

      }

      strcpy(exhosts[i], input);
      printf("Added %s to the scan exclude hosts\n", input);

   }

   return 1;
}

listhosts(int h) {

   int i=0;

   if(h) {

      while(strcmp(hosts[i], "")) {

         if(i%15 == 0 && i!=0) {
            printf("press enter\n");
            getc(stdin);
         }

         printf("%s\n", hosts[i]);
         i++;

      }

   }
   else {

       while(strcmp(exhosts[i], "")) {
             
          if(i%15 == 0 && i!=0) {
             printf("press enter\n");
             getc(stdin);
          }
 
          printf("%s\n", exhosts[i]);
          i++;
   
       }  

   }
}
