/*
lscan.c - local scanner
(c) Chopsui-cide/MmM '00
The Mad Midget Mafia - http://midgets.box.sk/
Ported to *NIX by Michael Stevens 
	http://openbsd.ods.org/

Quickly ascertains what ports can be bound to. This can be
used as a very fast method of finding what ports are open
on a Win9x/NT system. 
Ports that you just can't bind (if they're currently in use
by closed connections) to can be filtered out by adding
the -c parameter. This will attempt to connect to every port
that cannot be bound to. Ports that aren't actually open
will be marked as false. This would be far more useful if
ported to *nix.

usage: lscan <delay> [-a <localaddress>] [-c]
<delay>: delay in milliseconds between each port.
-c: confirm each port by connecting to self. -a parameter must
    be used.
-a: bind to <localaddress>. If this is not present, then
    INADDR_ANY will be used. You should scan first without
	this parameter, then with it using every ip address
	belonging to the system.

The fastest way to scan would be:
lscan 0

This will use up copious amounts of CPU time, so you may want
to increase the delay somewhat if this isn't your system. Also,
you should play around with the -a parameter, or you likely
won't get all the open ports.
If every port appears to be open (ie, you are being flooded with
results), then you are most probably trying to bind to an ip
address that does not belong to this system.

Do what you want with this file - just give me credit if you
modify it.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

int connect_sock(int sock, char *host, int port);
void usage();
void scan(unsigned long inaddr, char *localaddress, int delay);

int confirm;
int main(int argc, char *argv[])
{
	int a = 0;
	int c;
	confirm = 0;
	if (argc < 2) usage();
	if (argc > 2)
	{
		c = 2;
		do
		{
			if (!strcmp(argv[c], "-c")) confirm = 1;
			else if (!strcmp(argv[c], "-a"))
			{
				a = c;
				if (argc < c + 2) usage();
				c++;
			}
			else usage();
			c++;
		} while(c < argc);
	}
	if ((confirm) && (!a)) usage();
	if (!a) scan(INADDR_ANY, "127.0.0.1", atoi(argv[1]));
	else scan(inet_addr(argv[a + 1]), argv[a + 1], atoi(argv[1]));
	return 0;
}

int connect_sock(int sock, char *host, int port)
{
	struct sockaddr_in addr;
	struct hostent *he;

	memset(&addr, '0', sizeof(addr));

	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = inet_addr(host);
	addr.sin_port = htons(port);

	if ((he = gethostbyname(host)) != NULL) memcpy((char *)&addr.sin_addr, he->h_addr, he->h_length);
	else if ((addr.sin_addr.s_addr = inet_addr(host)) == -1)
	{
		printf("Local address invalid.");
		exit(1);
	}
	if (connect(sock, (struct sockaddr_in *)&addr, 16) == -1) return -1;
	return 0;
}

void usage()
{
	printf("usage: lscan <delay> [-a <localaddress>] [-c]\n<delay>: delay in milliseconds between each port.\n-c: confirm each port by connecting to self. -a parameter must\n");
    printf("    be used.\n-a: bind to <localaddress>. If this is not present, then\n    INADDR_ANY will be used. You should scan first without\n    this parameter, then with it using every ip address\n    belonging to the system.\n");
	exit(1);
}

void scan(unsigned long inaddr, char *localaddress, int delay)
{
	struct sockaddr_in addr;
	int p = 0;
	int s;
	int s2;
        printf(" Scanning \n");
	do
	{
		if ((s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
		{
			printf("Unable to create socket.\n");
			exit(1);
		}
		memset((char *)&addr,'0', sizeof(addr));
		addr.sin_family = AF_INET;
		addr.sin_addr.s_addr = inaddr;
		addr.sin_port = htons(p);

		if (bind(s, &addr, sizeof(addr)) == -1)
		{
                        printf("Open:  %d", p);
			if (confirm)
			{
				if ((s2 = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
				{
					printf("Unable to create socket.\n");
					exit(1);
				}
				if (connect_sock(s2, localaddress, p) == -1) printf(" [false]\n");
				else printf("\n");
				close(s2);
			}
			else printf("\n");
		}
		close(s);
		usleep(delay); // So we don't use up too much CPU time.
		p++;
	} while(p < 65535);
}
