// ---[ ipsweep.cpp ]--------------------------[ http://harmony.haxors.com ]---
// 
// this will scan an ip range and return any hosts which are up (or at least the
// ones which will respond to a ping because some dont). it will do a reverse dns
// lookup to give a little more info. why did microsoft make using the icmp protocol
// so arseways?
//
// ---[ harmony :: temple of the screaming interrupt ]--[ nomelody@gmx.net ]---

//--includes-------------------------------------------------------------------
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include "icmpdefs.h"
#include <conio.h>

//--function declerations------------------------------------------------------
int PingHost(char *current);
int ReverseDNS(char *current);

//--entry point----------------------------------------------------------------
int main(int argc, char **argv)
{

    WSAData wsaData;
    if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) {
        return 0;
    }

char start[16]="192.168.1.1", end[16]="192.168.1.254", current[16];
int a,b,c,d,e,f,g,h;
struct hostent *he;

sscanf(start,"%d.%d.%d.%d", &a, &b, &c, &d);
sscanf(end,"%d.%d.%d.%d", &e, &f, &g, &h);

    while(a <= 255){
            while(b <= 255){
                    while(c <= 255){
                            while(d <= 255){
                            sprintf(current, "%d.%d.%d.%d", a, b, c, d);
                                if(PingHost(current) == 0){
                                    ReverseDNS(current);
                                }
                                    if(strcmp(current, end) == 0){
                                    printf("\n\nfinished.\n");
                                    getch();
                                    return 0;
                                    }
                            d++;
                            }
                    c++;
                    d=0;
                    }
            c=0;
            d=0;
            b++;
            }
    c=0;
    d=0;
    b=0;
    a++;
    }

getch();
WSACleanup();
return 0;
}
//-----------------------------------------------------------------------------
int PingHost(char *current){
   // Load the ICMP.DLL
    HINSTANCE hIcmp = LoadLibrary("ICMP.DLL");
    if (hIcmp == 0) {
        printf("\nUnable to locate ICMP.DLL!");
        return 1;
    }

    // Look up an IP address for the given host name
    struct hostent* phe;

    if ((phe = gethostbyname(current)) == 0) {
        printf("\nerrror 1");
        return 1;
    }

    // Get handles to the functions inside ICMP.DLL that we'll need
    typedef HANDLE (WINAPI* pfnHV)(VOID);
    typedef BOOL (WINAPI* pfnBH)(HANDLE);
    typedef DWORD (WINAPI* pfnDHDPWPipPDD)(HANDLE, DWORD, LPVOID, WORD, PIP_OPTION_INFORMATION, LPVOID, DWORD, DWORD); // evil, no?
    pfnHV pIcmpCreateFile;
    pfnBH pIcmpCloseHandle;
    pfnDHDPWPipPDD pIcmpSendEcho;
    pIcmpCreateFile = (pfnHV)GetProcAddress(hIcmp, "IcmpCreateFile");
    pIcmpCloseHandle = (pfnBH)GetProcAddress(hIcmp, "IcmpCloseHandle");
    pIcmpSendEcho = (pfnDHDPWPipPDD)GetProcAddress(hIcmp, "IcmpSendEcho");

    if ((pIcmpCreateFile == 0) || (pIcmpCloseHandle == 0) || (pIcmpSendEcho == 0)) {
    printf("\nerrror 2");
    return 1;
    }

    // Open the ping service
    HANDLE hIP = pIcmpCreateFile();
    if (hIP == INVALID_HANDLE_VALUE) {
        printf("\nerrror 3");
        return 1;
    }
   
    // Build ping packet
    char acPingBuffer[64];
    memset(acPingBuffer, '\xAA', sizeof(acPingBuffer));
    PIP_ECHO_REPLY pIpe = (PIP_ECHO_REPLY)GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT,sizeof(IP_ECHO_REPLY) + sizeof(acPingBuffer));
    if (pIpe == 0) {
    printf("\nerrror 4");
    return 1;
    }
    pIpe->Data = acPingBuffer;
    pIpe->DataSize = sizeof(acPingBuffer);      

    // Send the ping packet
    DWORD dwStatus = pIcmpSendEcho(hIP, *((DWORD*)phe->h_addr_list[0]),acPingBuffer, sizeof(acPingBuffer), NULL, pIpe,sizeof(IP_ECHO_REPLY) + sizeof(acPingBuffer), 5000);
    if (dwStatus != 0) {
    /*
        printf("Addr: ");
                printf("%d.", int(LOBYTE(LOWORD(pIpe->Address))));
                printf("%d.", int(HIBYTE(LOWORD(pIpe->Address))));
                printf("%d.", int(LOBYTE(HIWORD(pIpe->Address))));
                printf("%d, ", int(HIBYTE(HIWORD(pIpe->Address))));
                printf("RTT: %d ", int(pIpe->RoundTripTime));
                printf("TTL: %d", int(pIpe->Options.Ttl));  */
    }
    else {
    printf("\nerrror 5");
    GlobalFree(pIpe);
    FreeLibrary(hIcmp);
    return 1;
    }

    // Shut down...
    GlobalFree(pIpe);
    FreeLibrary(hIcmp);
    return 0;
}
//-----------------------------------------------------------------------------
int ReverseDNS(char *current){

char name[256];
struct hostent *phostent;
struct sockaddr_in sock;
DWORD d = inet_addr(current);

phostent = gethostbyaddr( (char *)&d, 4, PF_INET );
    if(phostent != NULL ) {
    strcpy(name, phostent->h_name );
    } else{
    strcpy(name, "");
    }
printf("\nIP: %s\tFQDN: %s\tHost Type: %d", current, name, phostent->h_addrtype);
	for (int x = 0; *(phostent->h_aliases + x) != 0; x++){
    printf("\nHost Alias %d: %s",(x + 1),*(phostent->h_aliases + x));
    }
    for(int x = 0; *(phostent->h_addr_list + x) != 0; x++){
    memcpy(&sock.sin_addr.s_addr, *(phostent->h_addr_list + x), phostent->h_length);
    printf("\nIP Address %d: %s",(x + 1),inet_ntoa(sock.sin_addr));
	}

printf("/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/-/\n");
return 0;
}
//--EOF------------------------------------------------------------------------
