/*

   Banner Eater 0.1 - ICMP OS fingerprinting
   -----------------------------------------
   Michal Zalewski <lcamtuf@bos.bindview.com>

   Return values:

     0 - Unix
     1 - Windows
   100 - Error
   127 - Timeout

$Id: pingwin.c,v 1.3 2001/06/29 21:26:37 loveless Exp $

$Log: pingwin.c,v $
Revision 1.3  2001/06/29 21:26:37  loveless
Commented out almost all printing of text until I can add opt handling.
Mainly trying to clean up the output of bannereater.

Revision 1.2  2001/06/28 21:08:10  loveless
Minor adjustments for VLAD usage.


*/


#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <fcntl.h>

#include <netdb.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#include <pcap.h>
#include <net/bpf.h>

#include "bannereater.h"


char    errbuf[PCAP_ERRBUF_SIZE];
struct  bpf_program flt;
pcap_t* pt;


// Tweaked IP + ICMP packet header. Portable accross endians.

struct mypacket {
  u_char  ihl, tos, len1, len2, id1, id2, off1, off2, ttl, proto,
          ick1, ick2, S1, S2, S3, S4, D1, D2, D3, D4;
  u_char type,code,ck1,ck2,p1,p2,p3,p4,p5;
};


/***********************
 * Set up BPF receiver *
 ***********************/

void start_sniffing(char* host,char* eth) {
  char buf[1024];
  sprintf(buf,"icmp and icmp[0] = 0 and src host %s\n",host);
  if (!(pt=pcap_open_live(eth,250,0,0,errbuf))) {
    fprintf(stderr, "pcap_open_live failed: %s\n", errbuf);
    exit(100); // Error
  }
  if (pcap_compile(pt, &flt, buf, 1, 0)) {
    pcap_perror(pt,"pcap_compile");
    exit(100); // Error
  }
  pcap_setfilter(pt, &flt);
}


/****************
 * Parse packet *
 ****************/

void parse(u_char *blabla, struct pcap_pkthdr *pph, u_char *packet) {
  struct mypacket* x;
  if (*packet!=0x45) { packet+=14; pph->len-=14; };
  x=(void*)packet;
  // printf("Got response, operating system: %s\n",x->code?"Unix":"Windows");
  if (x->code) exit(0); // Unix
    else exit(1); // Windows
}


/*******************
 * Send ICMP query *
 *******************/

void send_evil_ping(char* host) {
  int sock,one=1;
  struct hostent* x;
  struct sockaddr_in sin;

  struct mypacket data = {

    // IP packet:
    0x45, 		// IHL
    0x08, 		// TOS
    0x00, 0x1d,		// total len
    0x12, 0x34,		// id
    0x00, 0x00,         // offset
    0x40,		// TTL
    0x01,		// ICMP
    0x00, 0x00,		// checksum
    0, 0, 0, 0,		// source addr
    0, 0, 0, 0,         // dest addr

    // ICMP packet:
    0x08,		// ECHO request
    0x01,		// ICMP code (non-zero, ha!)
    0x35, 0xb2,		// ICMP checksum
    0xc2, 0x4c, 0x00, 0x00, 0x00

  };

  x=gethostbyname(host);

  if (!x || !x->h_addr) { 
    fprintf(stderr,"Cannot determine host address.\n");
    exit(100);
  }

  // printf("Sending probe to %u.%u.%u.%u...\n",(unsigned char)x->h_addr[0],
  //  (unsigned char)x->h_addr[1],(unsigned char)x->h_addr[2],
  //  (unsigned char)x->h_addr[3]);

  sock=socket(AF_INET,SOCK_RAW,IPPROTO_RAW);

  if (sock<0) {
    fprintf(stderr,"Cannot open RAW socket.\n");
    exit(100);
  }

  setsockopt(sock,IPPROTO_IP,IP_HDRINCL,(char *)&one,sizeof(one));
  bzero(&sin,sizeof(sin));
  sin.sin_family = AF_INET;
  memcpy(&sin.sin_addr.s_addr,x->h_addr,4);

  data.D1  = x->h_addr[0];
  data.D2  = x->h_addr[1];
  data.D3  = x->h_addr[2];
  data.D4  = x->h_addr[3];

  sendto(sock,&data,sizeof(data), 0,(struct sockaddr *)&sin,
         sizeof(struct sockaddr));

}


/*******************
 * Handle timeouts *
 *******************/

void sigalrm(int dummy) { 
  // fprintf(stderr,"No response within %d seconds, exiting.\n",10);
  exit(127); // Not responding
}


/**********************
 * Sanity checks, etc *
 **********************/

int main(int argc,char* argv[]) {

  // fprintf(stdout,"pingwin 0.01b - ICMP OS fingerprinting by <lcamtuf@bos.bindview.com>\n");

  if (geteuid()) {
    fprintf(stderr,"FYI: pingwin needs root privileges to identify an OS.\n");
    exit(100);
  }

  if (argc<2 || argc>3) {
    fprintf(stderr,"Usage: %s hostname [ iface ]\n",argv[0]);
    exit(100);
  }

  signal(SIGALRM,sigalrm);
  alarm(10);

  start_sniffing(argv[1],(argc==3)?argv[2]:"eth0");
  send_evil_ping(argv[1]);
  pcap_dispatch(pt,1,(void*)parse,0);

  fprintf(stderr,"Some kind of error.\n");
  return 100; // Error

}
