/*

   Banner Eater 0.1
   ----------------
   Michal Zalewski <lcamtuf@bos.bindview.com>

$Id: bannereater.h,v 1.2 2001/06/28 21:04:22 loveless Exp $

$Log: bannereater.h,v $
Revision 1.2  2001/06/28 21:04:22  loveless
Updated for VLAD integration


*/

#ifndef _HAVE_BANNEREATER_H
#define _HAVE_BANNEREATER_H 1

#define BANNER_MAX	 128	// Max. banner length
#define MAX_CONNECT	 32	// Max. connections at the same time
#define MAX_LINE	 256    // Max. line length

#define PLATFORM_MS 	 1
#define PLATFORM_NON_MS  2
#define PLATFORM_ANY     (PLATFORM_MS | PLATFORM_NON_MS)

#define SEVERITY_UNKNOWN 0
#define SEVERITY_LOW	 1
#define SEVERITY_MEDIUM  2
#define SEVERITY_HIGH    3

#define STATUS_NOBANNER   1
#define STATUS_BANNER     2
#define STATUS_CONNFAIL   3

#define COMP_NONE	 0
#define COMP_ANY	 1
#define COMP_FULL	 2
#define COMP_PARTIAL     3

#define STATE_TI  	 0
#define STATE_DE	 1
#define STATE_PL	 2
#define STATE_PO	 3
#define STATE_SE	 4
#define STATE_CO	 5
#define STATE_BA	 6


struct be_entry {
  char* title;			// - short title
  char* description;		// - description filename
  char platform;		// - affected platform (PLATFORM_*)
  unsigned short port;		// - affected port
  char severity;		// - severity (SEVERITY_*)
  char type;			// - comparsion type (COMP_*)
  char* lookfor;		// - banner we are looking for
};


struct be_port {
  unsigned short port;		// - port number
  char status;			// - connection status (STATUS_*)
  char* banner;			// - gathered banner
};

#endif /* not _HAVE_BANNEREATER_H */
