/* udp-msglogger - udpserver.c, by pheisar@ccl.pt 
	
   udpserver(.c) saves the strings (packets) send by udpclient(.c) in a file (FILENAME).
   the file contains the hostname of the sender and, of course, the string.

   $ udpserver &		doesn't notify you about incoming messages.
   $ udpserver -n &	 	notifies you about incoming messages, to stderr (usually your shell).
   $ udpserver -h		help.

   file contents:

   [HOSTNAME] -> string (message)

*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> // sockaddr_in
#include <arpa/inet.h>
#include <unistd.h>

#define USAGE "usage: [-n] [-h] %s &\n", argv[0]
#define PORT 31337 	// server sitting on port 31337
#define FILENAME ".msgs"
#define MAXSIZE 1024
#define NOTIFY 1 	

void help(char *pname);

struct sockaddr_in s_addr, c_addr;	

void main(int argc, char **argv) 
{
	FILE *fd;
	
	int sfd, n, c_len, option;
	char mesg[MAXSIZE], c;

	if(argc > 2) {
		printf(USAGE);
		exit(1);
	}

	while( (c = getopt(argc, argv, "hn")) != EOF) {
		switch(c) {
			case 'h': help(argv[0]); break;
			case 'n': option = NOTIFY; break;	
			default: printf("What?\n"); exit(1);
		}
	}
	
	if( (fd = fopen(FILENAME, "a")) == NULL) {
		perror("fopen()");
		exit(1);
	}

	if( (sfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) { 
		perror("socket()");
		exit(1);
	} 

	memset((char *)&s_addr, 0, sizeof(s_addr));
	s_addr.sin_family = AF_INET;
	s_addr.sin_port = htons(PORT); 
	s_addr.sin_addr.s_addr = htonl(INADDR_ANY); // accepts everyone...
	
	if( (bind(sfd, (struct sockaddr *)&s_addr, sizeof(s_addr))) == -1) {
		perror("bind()");
		exit(1);
	}	

	for( ; ; ) {
		c_len = sizeof(c_addr);
		if( (n = recvfrom(sfd, mesg, sizeof(mesg), 0, (struct sockaddr *)&c_addr, &c_len)) < 0) {
			perror("recvfrom()");
			exit(1);
		} 
		
		if(option == NOTIFY)
		fprintf(stderr, "[%s] : message arrived from %s\n", argv[0], inet_ntoa(c_addr.sin_addr) );
		fprintf(fd, "[%s] -> %s\n", inet_ntoa(c_addr.sin_addr), mesg);
		fflush(fd);	
	}
	
	close(sfd);
	fclose(fd);
}

void help(char *pname)
{
	printf("usage: %s &\n", pname);
	printf("usage: %s [-h] \n", pname);
	printf("       %s [-n] &\n", pname);
	printf("options:\n");
	printf("	-h	this shit.\n");
	printf("	-n	notifies you about incoming messages, to stderr (usually your shell).\n");
	
	exit(1);
}


