/* udp-msglogger - udpclient.c, by pheisar@ccl.pt - read udpserver.c */

#include <stdio.h>
#include <string.h>	// memcpy()
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> // sockaddr_in structure
#include <netdb.h>	// gethostbyname()
#include <arpa/inet.h>	// inet_addr()

#define PORT 31337	// reaching port 31337 (server)
#define USAGE "usage: %s <hostname>\n", argv[0]
#define MAXSIZE 1024

extern int h_errno;	// herror()

struct sockaddr_in s_addr, c_addr;
struct hostent *host;

void main(int argc, char **argv)
{
	int sfd, n;
	char mesg[MAXSIZE];

	if(argc < 2) {
		printf(USAGE);
		exit(1);
	}
	
	memset((char *)&s_addr, 0, sizeof(s_addr));
	s_addr.sin_family = AF_INET;
	s_addr.sin_port = htons(PORT);
	if( (s_addr.sin_addr.s_addr = inet_addr(argv[1])) != 0xffffffff) { 
	} else {
		if( (host = gethostbyname(argv[1])) == NULL) {
			herror("gethostbyname()");	
			exit(1);
		}
		memcpy((char *)&s_addr.sin_addr, host->h_addr, host->h_length);
	}
 
	if( (sfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket()");
		exit(1);
	}
	
	memset((char *)&c_addr, 0, sizeof(c_addr));
	c_addr.sin_family = AF_INET;
	c_addr.sin_port = htons(0);
	c_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	

	// bind isn't needed, but it's cleaner...
	if( (bind(sfd, (struct sockaddr *)&c_addr, sizeof(c_addr))) == -1) {
		perror("bind()");
		exit(1);
	}

	printf("mesg: ");
	fgets(mesg, MAXSIZE, stdin);
	mesg[strlen(mesg)-1] = '\0';
	
	
	if( (n = sendto(sfd, mesg, sizeof(mesg), 0, (struct sockaddr *)&s_addr, sizeof(s_addr))) < 0) {
		perror("sendto()");
		exit(1);
	}
	
	printf("wrote %d bytes to %s.\n", sizeof(mesg), argv[1]);
	close(sfd);
}

