# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10719); 
 name["english"] = "MySQL Server version";
 script_name(english:name["english"]);

 desc["english"] = "This detects MySQL Server's version by connecting to the server and processing the buffer received.
This information gives potential attackers additional information about the system they are attacking. Versions should be omitted where possible.

Solution: Change the version number to something generic (like: 0.0.0.0)

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "MySQL Server version";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_require_ports("Services/mysql", 3306);
 exit(0);
}


#
# The script code starts here
#

port = get_kb_item("Services/mysql");
if (!port) port = 3306;

soctcp3306 = open_sock_tcp(port);
if (soctcp3306)
{
 result = recv(socket:soctcp3306, length:1000);
 
 if("is not allowed" >< result)
 	exit(0);

 mySQL_version = "";

 if ("is blocked" >< result)
 {
  exit(0);
 }

 if ((result[1] == raw_string(0x00)) && (result[2] == raw_string(0x00)) && (result[3] == raw_string(0x00)) && (result[4] == raw_string(0x0A))){
  end_found = FALSE;
  for (i = 0; end_found == FALSE ; i = i + 1)
  {
   if (result[5+i] == raw_string(0x00))
   {
    end_found = TRUE;
   }
   else
   {
    mySQL_version = string(mySQL_version, result[5+i]);
   }
  }
 }

 mySQL_version = string("Remote MySQL version : ", mySQL_version);

 set_kb_item(name:"mysql/version", value:mySQL_version);
 security_note(port:port, data:mySQL_version);
}
