#
# This script was written by Matt Moore <matt.moore@westpoint.ltd.uk>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10704);
 script_cve_id("CAN-2001-0731");
 name["english"] = "Apache Directory Listing";
 name["francais"] = "Apache Directory Listing";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
By making a request to the Apache web server ending in '?M=A' it is sometimes possible to obtain a 
directory listing even if an index.html file is present.

It appears that it is possible to retrieve a directory listing from the root of the Apache
web server being tested. However, this could be because there is no 'index.html' or similar 
default file present.
 
Solution: 

Unless it is required, turn off Indexing by making the appropriate changes to your 
httpd.conf file.

Risk Factor: Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks to see if Apache will provide a directory listing";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Matt Moore",
		  francais:"Ce script est Copyright (C) 2001 Matt Moore");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl","http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/apache");
 exit(0);
}

# Make a request for the root directory followed by ?M=A
# to see if Apache is misconfigured and will give a directory
# listing instead of the index.html page (or other default doc).
# 
# Could be improved to use output of webmirror.nasl to make requests for
# other directories which could be misconfigured, too.
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{ 
 req = http_get(item:"/", port:port);
 soc = open_sock_tcp(port);
 if(!soc)exit(0);
 send(socket:soc, data:req);
 r = recv(socket:soc, length:4096);
 close(soc);
 if("Index of " >< r)exit(0);

 req = http_get(item:"/?M=A", port:port);
 soc = open_sock_tcp(port);
 if(soc)
 {
 send(socket:soc, data:req);
 r = recv(socket:soc, length:1024);
 close(soc);
 if (("Index of " >< r) && ("Last modified" >< r))	
 	security_warning(port);
 }
}
