#!/usr/bin/perl
#
#                       *-  Small disclaimer -*
#
# Sprint written by zillion ( zillion@safemode.org ) This tool has
# been written for educational purpose. Usage of this tool is completely
# for your own risk. Abuse of this tool is easy to detect by the web
# sites that have been the target of it.
#
# This script requires Net::RawIP which can be obtained from:
# http://quake.skif.net/RawIP/
#
#
#

use Net::RawIP; 

require 'getopts.pl';

Getopts('s:v:p:c:');

if(!defined $opt_s) {

print <<"END";

----------------------------------------------------------------------
   *-  Sprint operating system fingerprinting tool version 0.3 -*
----------------------------------------------------------------------

         Usage $0 -s <target ip> -p <target port>
          
  The port has to be open in order to make an acurate operating 
  system guess. Sprint sends several packets to the target host
  and analyses the responses in order to make an operating system
  guess. This works the same as nmap and queso. Currently Sprint
  is not as acurate as Nmap I think it is more acurate then queso.

                          Special options

  -v debug : This will print out more output like received packets.
  -c file  : This can be used to use a different signature file. 

----------------------------------------------------------------------
END

exit;

}

if( -f "sprint.conf") {  

require 'sprint.conf'; 

} else {

&conf_error;

}

$port = $opt_p; 

print <<START;

-------------------------------------------------------------------------
            *-- Starting to fingerprint the remote host --*
-------------------------------------------------------------------------

START
@flags = qw/SEQ ACK_SEQ DOFF URG ACK PSH RST SYN FIN WIN CHECK URG_PTR/; 

$filter = "src host $opt_s and src port $port";
$psize = 1500;
my $pck = new Net::RawIP; 

if(fork()){

    $b = new Net::RawIP;
    my $pcap = $b->pcapinit($dev,$filter,$psize,10);
    
$SIG{ALRM} = \&timed_out;
    eval {
	alarm (5);
	
	loop $pcap,6,\&analyse,\@a;
	
	alarm(0);           # Cancel the pending alarm
    };
    if ($@ =~ /Aarrgghhh/) {
	
	if(@result) {
	    
	    @ar = sort @result; 
	    
	    if($opt_c) {
		
		open(SIG, "<./$opt_c") || die("cannot open alternative signature file...");
		
	    } else {
		
		open(SIG, "<./systems.sig") || die("cannot open signature file, try the -c option...");

		
	    }	
	    
	    while(<SIG>) {
		
		if($_ =~ /:: @ar :: (.*)/) {	
		    
		    print "\nResult from $opt_s : $1\n\n";
		    print "-------------------------------------------------------------------------\n";
		    $found = 1

		}

		if($_ =~ /.* $win .* :: (.*)/) {

		    push @guesses ,"$1";

		}

	    }

	    close(SIG);

		if(!defined $found) {

		    if(@guesses) { 

			print "\nOS Guesses: @guesses\n";

		    }
		} 

	  

	    
	} else { 
	    
	    print "Sorry the server returned no packets..\n";
	    exit;
	}
	
    }
    
    sub timed_out {
	die "Aarrgghhh cannot wait any longer....";
    }


}else {
    
    sleep 3;

&send_packet;

}

sub send_packet {
    
    $pkt = new Net::RawIP;
    
    $data = "s-m0de owns..." x 6;
    
    
    $pkt->set({ ip => {saddr => $ip,
		       ttl => 66,
		       daddr => $opt_s
                 },
			   tcp=> {dest => $opt_p,
                                  data => $data,
		 		   ack => 0,
			 	   fin => 0,
			        source => 1121,
                                   syn => 1}
      });
 
    $pkt->send(0,1);
    
    $pkt->set({ ip => {saddr => $ip,
		       ttl => 66,
		       daddr => $opt_s
		       },
                     tcp=> {dest => $opt_p,
                            data => $data,
                             ack => 1,
                             fin => 0,
                          source => 1111,
                             syn => 1}
      });
 
    $pkt->send(0,1);
    
    $pkt->set({ ip => {saddr => $ip,
                 ttl => 66,
                 daddr => $opt_s
                 },
                     tcp=> {dest => $opt_p,
                            data => $data,
                             ack => 0,
                             fin => 1,
                          source => 1111,
                             syn => 0}
      });
 
    $pkt->send(0,1);
    
    $pkt->set({ ip => {saddr => $ip,
                 ttl => 66,
                 daddr => $opt_s
                 },
                     tcp=> {dest => $opt_p,
                            data => $data,
                             ack => 0,
                             fin => 1,
                          source => 1111,
                             syn => 1}
      });
 
    $pkt->send(0,1);
    
    
    $pkt->set({ ip => {saddr => $ip,
                 ttl => 66,
                 daddr => $opt_s
                 },
                     tcp=> {dest => $opt_p,
                            data => $data,
                             ack => 1,
                             fin => 1,
                             urg => 1,
                             psh => 1,
                          source => 1111,
                             syn => 1}
      });
 
    $pkt->send(0,1);
    
}

sub analyse {
    $b->bset(substr( $_[2],14));
    my @fl = $b->get({tcp=>
			  [qw(seq ack_seq doff psh syn fin rst urg ack window check urg_ptr)]
			  });
    map { push @result, "$flags[$_]" if $fl[$_] } (0..12);
    
    $win = $fl[9] if($fl[9]);

    if($win) {
	
	push @result, "$win";

   }
 
    if($opt_v =~ /debug/)  {
	    
	    print "Server -> ";
	
	map { print "$flags[$_] "  if $fl[$_] } (0..12);



    print "\n";

 }

}

sub conf_error {

print <<AIAI;
 
It seems that the configuration file is not available or contains
errors. Before you can use sprint a few thing have to be defined:
your ip (like 1.1.1.1) and the device you like to listen on for
returned packets (like eth0).
 
AIAI
 
open(CONF, ">./sprint.conf");
 
print "What is your ip address: ";
$ip = <STDIN>;
 
print "What is your network device: ";
$dev = <STDIN>;
 
chop($ip,$dev);
 
print CONF <<TUKKER;
\#
\# Sprint configuration file..
\#
 
\$dev = "$dev"; \# device to listen on
\$ip = "$ip";   \# ip to listen for
TUKKER
 
close(CONF);

}

