/*
 * "show_leaks" is a dumb program that analyzes /tmp/nessus-mem-leaks.PID
 * and tells us which malloc() calls have not been freed.
 *
 * If you're looking for a nice way to debug memory leaks, I suggest
 * dmalloc (www.dmalloc.org). I did not use it because I discovered it
 * too late AND Nessus has its own emalloc()/efree() calls already, so
 * using dmalloc() is not easy (but not to complicated either).
 *
 * If you want to debug memory leaks in Nessus :
 * 	- make sure everything is compiled with -DHUNT_MEM_LEAKS
 * 	- use this program to analyze /tmp/nessus-mem-leaks.PID
 *
 * As of Nessus 1.1.6, we don't have any mem leak in the "core"
 * part which tests a network again and again (that was the most critical
 * one)
 *
 * Note that this source file is to be compiled manually, (gcc -o show_leaks 
 * show_leaks.c)
 *
 * Usage :
 *
 * ./show_leaks < /tmp/nessus-memleaks.PID | grep PID_OF_PROCESS_WHICH_LEAKS_MEM
 *
 * It will show :
 * 	- the superfluous "free()" calls (not always an error - a son may
 * 	  free memory that was allocated by his father)
 *
 * 	- show the malloc() calls that have not been freed.
 *
 */
#include <stdio.h>
#include <stdlib.h>

struct link {
	long mem_address;
	char * allocated_by;
	int pid;
	struct link * next;
};


int is_present(links, addr, pid)
 struct link * links;
 long addr;
 int pid;
{
 while(links)
 {
  if((links->mem_address == addr) &&
     (links->pid == pid))
   		return 1;
  links = links->next;
 }
 return 0;
}
struct link * 
add_alloc(links,line)
 struct link * links;
 char * line;
{
  struct link * ret;
  char * end = NULL;
 
  ret = malloc(sizeof(*ret));
  ret->allocated_by = (char*)strdup(line);
  ret->mem_address = strtol(line, &end, 16);
  ret->pid = atoi(end);
 if(is_present(links, ret->mem_address, ret->pid))
   {
	printf("??????? 0x%x DUPLICATED\n", ret->mem_address);
   }
  ret->next = links; 
  return ret;
}


struct link * 
rm_alloc(links, line)
	struct link * links;
	char * line;
{
  char * end;
 long addr;
 int pid;
 struct link * start = links;
 struct link * prev = NULL;
 char * copy = (char*)strdup(line);
 
 addr = strtol(line, &end, 16);
 pid = atoi(end);
 while(links)
 {
  if((addr == links->mem_address)  &&
     (pid == links->pid))
  {
	  if(prev)
	  {
	   prev->next = links->next;
	   free(links->allocated_by);
	   free(links);
	   free(copy);
	   return start;
	  }
	  else
	  {
	   start = links->next;
	   free(links->allocated_by);
	   free(links);
	   free(copy);
	   return start;
	  }
  }
  else {
	  prev = links;
	  links = links->next;
  }
 }
 printf("????? 0x%x not found!! - %s\n", addr, copy);
 free(copy);
 return start;
}


int main()
{
 struct link * links = NULL;
 char *buf = malloc(255);
 bzero(buf, 255);
 while(fgets(buf, 254, stdin))
 {
  if(strstr(buf, "allocated"))
   links = add_alloc(links, buf);
  else
   links = rm_alloc(links, buf);
 bzero(buf, 255);  
 }

 while(links)
 {
  printf("%s\n", links->allocated_by);
  links = links->next;
 }
 return 0;
}
