# base on cross_site_scripting.nasl, from various people

if (description)
{
 script_id(11010);
 script_version("$Revision: 1.1 $");
 script_name(english:"WebSphere Cross Site Scripting");
 desc["english"] = 
"The remote web server seems to be vulnerable to the Cross Site Scripting 
vulnerability. The vulnerability is caused by the result returned to the 
user when a non-existing file is requested (e.g. the result contains the 
JavaScript provided in the request).
The vulnerability would allow an attacker to make the server present the 
user with the attacker's JavaScript/HTML code.
Since the content is presented by the server, the user will give it 
the trust level of the server (for example, the trust l
evel of banks, shopping centers, etc. would usually be high).

Risk factor : Medium

Solution : Upgrade to the latest version of WebSphere
";


 script_description(english:desc["english"]);
 script_summary(english:"Determine if the remote host is vulnerable to Cross Site Scripting vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"(c) 2002 Renaud Deraison");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/ibm-http");
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;



if(get_port_state(port))
{
  soc = http_open_socket(port);
  if(soc)
   {
    url = string("/../<SCRIPT>alert('Vulnerable')</SCRIPT>");
    confirmtext = string("<SCRIPT>alert('Vulnerable')</SCRIPT>"); 
    req = http_get(item:url, port:port);
    send(socket:soc, data:req);
    head = http_recv_headers(soc);
    r = recv(socket:soc, length:40960);
    close(soc);
    
    if(confirmtext >< r)
      {
       security_hole(port);
       exit(0);
      }
   }
}

