if(description)
{
 script_id(10878);
 script_version("$Revision: 1.2 $");
 name["english"] = "Sun Cobalt Adaptive Firewall Detection";
 script_name(english:name["english"]);
 
 desc["english"] = "
Sun Cobalt machines contain a firewall mechanism, this mechanism can be
configured remotely by accessing Cobalt's built-in HTTP server. Upon access to
the HTTP server, a java based administration program would start, where a user
is required to enter a pass phrase in order to authenticate himself. Since no
username is required, just a passphrase bruteforcing of this interface is
easier.

Solution : 
Access to this port (by default set to port 8181) should not be permitted from
the outside. Further access to the firewall interface itself should not be
allowed (by default set to port 2005).

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Sun Cobalt Adaptive Firewall Detection";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 SecurITeam");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 8181);
 exit(0);
}

# Check starts here

function check(req)
{
 soc = open_sock_tcp(port);
 if(soc)
 {

  req = http_get(item:req, port:port);

  send(socket:soc, data:req);
  buf = recv(socket:soc, length:4096);

  close(soc);

  if (("Sun Cobalt Adaptive Firewall" >< buf) && ("One moment please" >< buf))
  {
   	security_warning(port:port);
	return(1);
  }
 }
 return(0);
}

port = get_kb_item("Services/www");
if(!port)port = 8181;
cginameandpath[0] = string("/");
cginameandpath[1] = string(cgibin()) + string("/");
cginameandpath[2] = "";

i = 0;
if(get_port_state(port))
{
 for (i = 0; cginameandpath[i]; i = i + 1)
 { 
  url = cginameandpath[i];
  if(check(req:url))exit(0);
 }
}

