#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10765);
 script_version ("$Revision: 1.6 $");

name["english"] = "SQLQHit Directory Structure Disclosure";
 script_name(english:name["english"]);

 desc["english"] = "
The Sample SQL Query CGI is present. 
The sample allows anyone to structure a certain query that would retrieve
the content of directories present on the local server.

Solution: Use Microsoft's Secure IIS Guide (For IIS 4.0 or IIS 5.0 respectively) or  
Microsoft's IIS Lockdown tool to remove IIS samples.

Risk factor : Medium

Additional information:
http://www.securiteam.com/tools/5QP0N1F55Q.html (IIS Lookdown)
http://www.securiteam.com/windowsntfocus/5HP05150AQ.html (Secure IIS 4.0)
http://www.securiteam.com/windowsntfocus/5RP0D1F4AU.html (Secure IIS 5.0)
";

 script_description(english:desc["english"]);

 summary["english"] = "SQLQHit Directory Stracture Disclosure";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[0] = "/";
dir[1] = "/search/";
dir[2] = "/iissamples/issamples/";
dir[3] = "/ISSamples/";
dir[4] = "/asp/";
dir[5] = "/oc/Search/";
dir[6] = "/search/htx/";

program[0] = "sqlqhit.asp";
program[1] = "SQLQHit.asp";

port = get_kb_item("Services/www");
if (!port) port = 80;


for (i = 0; dir[i] ; i = i + 1)
{
 for (j = 0; program[j] ; j = j + 1)
 {
  url = string(dir[i], program[j]);
  #display("Trying: ", url, "\n");
  if (is_cgi_installed(url))
  {
   #display("Found SQLQHit at: ", url, "\n");

   url = string(dir[i], program[j], "?CiColumns=*&CiScope=webinfo");
   #display("url: ", url, "\n");

   req = http_get(item:url, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:2048);

    #display(buf);
    
    if (("VPATH" >< buf) && ("PATH" >< buf) && ("CHARACTERIZATION" >< buf))
    {
     security_hole(port:port);
     exit(0);
    }
   }
  }
 }
}

