#
# This script was written by Michael Scheidell <scheidell at secnap.net>
#
# See the Nessus Scripts License for details
#
if(description)
{
 script_id(10943);
 script_cve_id("CAN-2002-0071");
 script_version("$Revision: 1.2 $");
 name["english"] = "Cumulative Patch for Internet Information Services (Q319733)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Cumulative Patch for Microsoft IIS (Q319733)

Impact of vulnerability: Ten new vulnerabilities, the most
serious of which could enable code of an attacker's choice
to be run on a server.

Recommendation: Users using any of the affected
products should install the patch immediately.

Maximum Severity Rating: Critical 

Affected Software: 

Microsoft Internet Information Server 4.0 
Microsoft Internet Information Services 5.0 
Microsoft Internet Information Services 5.1 

See
http://www.microsoft.com/technet/security/bulletin/ms02-018.asp

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines whether April 10th ,2002 IIS Cumulative patch's (Q319733) are installed";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michael Scheidell");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl",
		     "smb_reg_service_pack_W2K.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_access","SMB/WindowsVersion");
 script_exclude_keys("SMB/XP/ServicePack");
 script_require_ports(139);
 exit(0);
}

include("smb_nt.inc");

access = get_kb_item("SMB/registry_access");
if(!access)exit(0);

version = get_kb_item("SMB/WindowsVersion");

if(version >< "5.0")
{
# fixed in Service Pack 3
 sp = get_kb_item("SMB/Win2K/ServicePack");
 if(ereg(string:sp, pattern:"Service Pack [3-9]"))exit(0);
}

if(version >< "5.1")
{
 # fixed in XP service Pack 1
 sp = get_kb_item("SMB/XP/ServicePack");
 if(sp)exit(0);
}

key = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\Q319733";
item = "Comments";
value = registry_get_sz(key:key, item:item);
if(!value)security_hole(139);
