#
# This script was written by Michael Scheidell <scheidell at secnap.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10861);
 script_version("$Revision: 1.5 $");
 script_cve_id("CAN-2001-0727");
 name["english"] = "IE 5.01 5.5 6.0 Cumulative patch (Q316059)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The 11 February 2002 Cumulative Patch for IE is
not applied on the remote host.

Impact of vulnerability: Run code of attacker's choice. 

Recommendation: Customers using IE should install the patch immediately. 

Affected Software: 

Microsoft Internet Explorer 5.01
Microsoft Internet Explorer 5.5 
Microsoft Internet Explorer 6.0 

NOTE: Might require full registry access on win2k and xp

Supersedes MS01-055 and ms01-058

See http://www.microsoft.com/technet/security/bulletin/ms02-005.asp

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines whether the hotfix Q313675 is installed";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michael Scheidell");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl", "smb_registry_full_access.nasl",
 		     "smb_reg_service_pack.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access");
 script_require_ports(139);
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}

include("smb_nt.inc");
access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);

version = get_kb_item("SMB/WindowsVersion");


if(version)
{
 key = "SOFTWARE\Microsoft\Internet Explorer\Version Vector";
 item = "IE";
 value = string(registry_get_sz(key:key, item:item));

 if(!value)
 {
   security_note(port:139,data:"We were unable to determine what version of IE you are running");
   exit(0);
 }

 report = string("We were able to determine that you are running IE Version ",value);
 
 key =  "SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings";
 item = "MinorVersion";
 minorversion = string(registry_get_sz(key:key, item:item));

 if(minorversion)
    report = report + string("\nwith these IE Hotfixes installed:",minorversion);

 if( !("Q316059" >< minorversion))
   {
    report = report + string("\n
Recommendation: Customers using Microsoft IE  should install
this patch immediately. 

Impact of vulnerability: Run code of attacker's choice. 

See http://www.microsoft.com/technet/security/bulletin/ms02-005.asp
Supersedes MS01-055 and MS01-058\n\n

Risk factor : High");

   security_hole(port:139, data:report);
  }
 else
   security_note(port:139, data:report);
}

