#
# smb_nt.inc 
# $Revision: 1.14 $
#

#-----------------------------------------------------------------#
# Reads a SMB packet						  #
#-----------------------------------------------------------------#
function smb_recv(socket, length)
 {
   ____msg_header = recv(socket:socket, length:4);
   if (strlen(____msg_header) < 4)return(0);
   ____msg_trailer_length = 256 * ord(____msg_header[2]);
   ____msg_trailer_length = ____msg_trailer_length + ord(____msg_header[3]);
   if (____msg_trailer_length == 0)return(____msg_header);
   ____msg_trailer = recv(socket:socket, length:____msg_trailer_length);
   if(strlen(____msg_trailer) < ____msg_trailer_length)return(0);
   return(____msg_header+____msg_trailer);
 }

#-----------------------------------------------------------------#
# Convert a netbios name to the netbios network format            #
#-----------------------------------------------------------------#
function netbios_name(orig)
{
 ret = "";
 len = strlen(orig);
 for(i=0;i<16;i=i+1)
 {
   if(i >= len)
   {
     c = "CA";
   }
   else
   {
     o = ord(orig[i]);
     odiv = o/16;
     odiv = odiv + ord("A");
     omod = o%16;
     omod = omod + ord("A");
     c = raw_string(odiv, omod);
   }
 ret = ret+c;
 }
 return(ret); 
}

#--------------------------------------------------------------#
# Returns the netbios name of a redirector                     #
#--------------------------------------------------------------#

function netbios_redirector_name()
{
 ret = crap(data:"CA", length:30);
 ret = ret+"AA";
 return(ret); 
}

#-------------------------------------------------------------#
# return a 28 + strlen(data) + (odd(data)?0:1) long string    #
#-------------------------------------------------------------#
function unicode(data)
{
 len = strlen(data);
 ret = raw_string(ord(data[0]));
 
 for(i=1;i<len;i=i+1)
 {
  ret = string(ret, raw_string(0, ord(data[i])));
 }
 
 
 if(!(len & 1)){even = 1;}
 else even = 0;
 

 for(i=0;i<7;i=i+1)
  ret = ret + raw_string(0);
  
  
 if(even)
  {
  ret = ret + raw_string(0x00, 0x00, 0x19, 0x00, 0x02, 0x00);
  }
 else
  ret = ret + raw_string(0x19, 0x00, 0x02, 0x00);
 
  
 return(ret);
}




#----------------------------------------------------------#
# Request a new SMB session                                #
#----------------------------------------------------------#
function smb_session_request(soc, remote)
{
 nb_remote = netbios_name(orig:remote);
 nb_local  = netbios_redirector_name();
 
 session_request = raw_string(0x81, 0x00, 0x00, 0x44) + 
		  raw_string(0x20) + 
		  nb_remote +
		  raw_string(0x00, 0x20)    + 
		  nb_local  + 
		  raw_string(0x00);

 send(socket:soc, data:session_request);
 r = smb_recv(socket:soc, length:4000);
 if(ord(r[0])==0x82)return(r);
 else return(FALSE);
}

#------------------------------------------------------------#
# Extract the UID from the result of smb_session_setup()     #
#------------------------------------------------------------#

function session_extract_uid(reply)
{
 low = ord(reply[32]);
 high = ord(reply[33]);
 ret = high * 256;
 ret = ret + low;
 return(ret);
}



#-----------------------------------------------------------#
# Negociate (pseudo-negociate actually) the protocol        #
# of the session                                            #
#-----------------------------------------------------------#


function smb_neg_prot(soc)
{
 neg_prot = raw_string
   	(
	 0x00,0x00,
	 0x00, 0x89, 0xFF, 0x53, 0x4D, 0x42, 0x72, 0x00,
	 0x00, 0x00, 0x00, 0x18, 0x01, 0x20, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x66, 0x00, 0x02, 0x50, 0x43,
	 0x20, 0x4E, 0x45, 0x54, 0x57, 0x4F, 0x52, 0x4B,
	 0x20, 0x50, 0x52, 0x4F, 0x47, 0x52, 0x41, 0x4D,
	 0x20, 0x31, 0x2E, 0x30, 0x00, 0x02, 0x4D, 0x49,
	 0x43, 0x52, 0x4F, 0x53, 0x4F, 0x46, 0x54, 0x20,
	 0x4E, 0x45, 0x54, 0x57, 0x4F, 0x52, 0x4B, 0x53,
	 0x20, 0x31, 0x2E, 0x30, 0x33, 0x00, 0x02, 0x4D,
	 0x49, 0x43, 0x52, 0x4F, 0x53, 0x4F, 0x46, 0x54,
	 0x20, 0x4E, 0x45, 0x54, 0x57, 0x4F, 0x52, 0x4B,
	 0x53, 0x20, 0x33, 0x2e, 0x30, 0x00, 0x02, 0x4c,
	 0x41, 0x4e, 0x4d, 0x41, 0x4e, 0x31, 0x2e, 0x30,
	 0x00, 0x02, 0x4c, 0x4d, 0x31, 0x2e, 0x32, 0x58,
	 0x30, 0x30, 0x32, 0x00, 0x02, 0x53, 0x61, 0x6d,
	 0x62, 0x61, 0x00
	 );
	 
 send(socket:soc, data:neg_prot);
 r = smb_recv(socket:soc, length:4000);
# mss testing
 if(strlen(r) < 10)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);
}
 

#------------------------------------------------------#
# Set up a session                                     #
#------------------------------------------------------#
function smb_session_setup(soc, login, password, domain)
{
  extra = 0;
  native_os = "Unix";
  native_lanmanager = "Nessus";
  if(!domain)domain = "MYGROUP";

  if(domain) extra = 3+ strlen(domain) + strlen(native_os) + strlen(native_lanmanager);
  else extra = strlen(native_os) + strlen(native_lanmanager) + 2;


  
  len = strlen(login) + strlen(password) + 57 + extra;
  bcc = 2 + strlen(login) + strlen(password) + extra;
  
  len_hi = len / 256;
  len_low = len % 256;
  
  bcc_hi = bcc / 256;
  bcc_lo = bcc % 256;
  
  pass_len = strlen(password) + 1 ;
  pass_len_hi = pass_len / 256;
  pass_len_lo = pass_len % 256;
  
  st = raw_string(0x00,0x00,
    	  len_hi, len_low, 0xFF, 0x53, 0x4D, 0x42, 0x73, 0x00,
	  0x00, 0x00, 0x00, 0x18, 0x01, 0x20, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00,
	  0x00, 0x00, 0x0A, 0xFF, 0x00, 0x00, 0x00, 0x04,
	  0x11, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	  0x00, pass_len_lo,  pass_len_hi, 0x00, 0x00, 0x00, 0x00, bcc_lo,
	  bcc_hi) + password + raw_string(0) + login + raw_string(0x00);
	  
  if(domain)
  	st = st + domain + raw_string(0x00);	
	
  st = st + native_os + raw_string(0x00) + native_lanmanager + raw_string(0x00);
  	  
  send(socket:soc, data:st);
  r = smb_recv(socket:soc, length:1024); 
  if(strlen(r) < 9)return(FALSE);
  if(ord(r[9])==0)return(r);
  else return(FALSE);
}	   


#------------------------------------------------------#
# connection to a remote share                         #
#------------------------------------------------------#		
#
# connection to the remote IPC share
#		
function smb_tconx(soc,name,uid, share)
{

 high = uid / 256;
 low = uid % 256;
 len = 48 + strlen(name) + strlen(share) + 6;
 ulen = 5 + strlen(name) + strlen(share) + 6;
 
 
 
 req = raw_string(0x00, 0x00,
 		  0x00, len, 0xFF, 0x53, 0x4D, 0x42, 0x75, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x01, 0x20, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, low, high,
		  0x00, 0x00, 0x04, 0xFF, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x01, 0x00, ulen, 0x00, 0x00, 0x5C, 0x5C) +
	name + 
	raw_string(0x5C) + share +raw_string(0x00) +
	"?????"  + raw_string(0x00);
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:1024);
 if(!r)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);		   	 

}

#------------------------------------------------------#
# Extract the TID from the result of smb_tconx()       #
#------------------------------------------------------#
function tconx_extract_tid(reply)
{
 low = ord(reply[28]);
 high = ord(reply[29]);
 ret = high * 256;
 ret = ret + low;
 return(ret);
}


#--------------------------------------------------------#
# Request the creation of a pipe to winreg. We will      #
# then use it to do our work                             #
#--------------------------------------------------------#
function smbntcreatex(soc, uid, tid)
{
 tid_high = tid / 256;
 tid_low  = tid % 256;
 
 uid_high = uid / 256;
 uid_low  = uid % 256;
 
  req = raw_string(0x00, 0x00,
  		   0x00, 0x5B, 0xFF, 0x53, 0x4D, 0x42, 0xA2, 0x00,
		   0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x50, 0x81,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		   0x00, 0x00, 0x18, 0xFF, 0x00, 0x00, 0x00, 0x00,
		   0x07, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x9F, 0x01, 0x02, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		   0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00,
		   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
		   0x00, 0x00, 0x00, 0x08, 0x00, 0x5C, 0x77, 0x69,
		   0x6e, 0x72, 0x65, 0x67, 0x00);

 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4000);
 if(strlen(r) < 10)return(FALSE);
 if(ord(r[9])==0x00)return(r);
 else return(FALSE);
}


#--------------------------------------------------------#
# Extract the ID of our pipe from the result             #
# of smbntcreatex()                                      #
#--------------------------------------------------------#

function smbntcreatex_extract_pipe(reply)
{
 low = ord(reply[42]);
 high = ord(reply[43]);
 
 ret = high * 256;
 ret = ret + low;
 return(ret);
}



#---------------------------------------------------------#
# Determines whether the registry is accessible           #
#---------------------------------------------------------#
		
function pipe_accessible_registry(soc, uid, tid, pipe)
{
 tid_low = tid % 256;
 tid_high = tid / 256;
 uid_low = uid % 256;
 uid_high = uid / 256;
 pipe_low = pipe % 256;
 pipe_high = pipe / 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x94, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x1B, 0x81,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x48, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C,
		  0x00, 0x48, 0x00, 0x4C, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, 0x51, 0x00, 0x5C, 0x50, 0x49,
		  0x50, 0x45, 0x5C, 0x00, 0x00, 0x00, 0x05, 0x00,
		  0x0B, 0x00, 0x10, 0x00, 0x00, 0x00, 0x48, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x16,
		  0x30, 0x16, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xd0,
		  0x8c, 0x33, 0x44, 0x22, 0xF1, 0x31, 0xAA, 0xAA,
		  0x90, 0x00, 0x38, 0x00, 0x10, 0x03, 0x01, 0x00,
		  0x00, 0x00, 0x04, 0x5D, 0x88, 0x8A, 0xEB, 0x1C,
		  0xc9, 0x11, 0x9F, 0xE8, 0x08, 0x00, 0x2B, 0x10,
		  0x48, 0x60, 0x02, 0x00, 0x00, 0x00);	  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 10)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);
}


#----------------------------------------------------------#
# Step 1                                                   #
#----------------------------------------------------------#

function registry_access_step_1(soc, uid, tid, pipe)
{
 tid_low = tid % 256;
 tid_high = tid / 256;
 uid_low = uid % 256;
 uid_high = uid / 256;
 pipe_low = pipe % 256;
 pipe_high = pipe / 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x78, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x80, 0x1D, 0x83,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x24, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x24, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, 0x35, 0x00, 0x00, 0x5c, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x24, 0x00,
		  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x10, 0xFF,
		  0x12, 0x00, 0x30, 0x39, 0x01, 0x00, 0x00, 0x00,
		  0x00, 0x02);
		  

 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 10)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);
}


#---------------------------------------------------------------------#
# Get the key                                                         #
#---------------------------------------------------------------------#
		 
function registry_get_key(soc, uid, tid, pipe, key, reply)
{
 key_len = strlen(key) + 1;
 key_len_hi = key_len / 256;
 key_len_lo = key_len % 256;
 
 
 
 tid_low = tid % 256;
 tid_high = tid / 256;
 uid_low = uid % 256;
 uid_high = uid / 256;
 pipe_low = pipe % 256;
 pipe_high = pipe / 256;
 uc = unicode(data:key);
 
 len = 148 + strlen(uc);
 
 len_hi = len / 256;
 len_lo = len % 256;
 
 
 z = 40 + strlen(uc);
 z_lo = z % 256;
 z_hi = z / 256;
 
 y = 81 + strlen(uc);
 y_lo = y % 256;
 y_hi = y / 256;
 
 x = 64 + strlen(uc);
 x_lo = x % 256;
 x_hi = x / 256;
 
 if(strlen(reply) < 17)exit(0);
 magic1 = raw_string(ord(reply[16]), ord(reply[17]));
 
 req = raw_string(0x00, 0x00,
 		  len_hi, len_lo, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x80)
		  +
		  magic1 +
		 raw_string(
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00,tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, x_lo, x_hi, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, x_lo, x_hi, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, y_lo, y_hi, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0xb9, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, x_lo, x_hi,
		  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, z_lo, z_hi,
		  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00);
		  
 magic = raw_string(ord(reply[84]));
 for(i=1;i<20;i=i+1)
 {
  magic = magic + raw_string(ord(reply[84+i]));
 }
 
 x = strlen(key) + strlen(key) + 2;
 x_lo = x % 256;
 x_hi = x / 256;
 
 req = req + magic + raw_string(x_lo, x_hi, 0x0A, 0x02, 0x00, 0xEC,
 		0xFD, 0x7F, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, key_len_lo, key_len_hi, 0x00, 0x00) +
		uc;
		  

 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 10)return(FALSE);
 
 len = ord(r[2])*256;
 len = len + ord(r[3]);
 if(len < 100)return(FALSE);
 if(ord(r[9])==0)return(r);
 else return(FALSE);
}

#---------------------------------------------------------------------#
# Get the security descriptor for a key                               #
#---------------------------------------------------------------------#


function registry_get_key_security(soc, uid, tid, pipe, reply)
{
 req = raw_string(0x00, 0x00,
 		  0x00, 0x9C, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x80, 0x00, 0x83,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x48, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x48, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, 0x59, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0xEE, 0xD5, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x48, 0x00,
		  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x30, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00);
 
 magic = raw_string(ord(reply[84]));		  
 for(i=1;i<20;i=i+1)
 {
  magic = magic + raw_string(ord(reply[84+i]));
 }
 
 req = req + magic + raw_string(0x04, 0x00, 0x00, 0x00, 0x50, 0x22,
       0x7C, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
 
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:65535);
 return(r);
}

 
		 
#---------------------------------------------------------------------#
# returns 'TRUE' if <key> is writeable				      #
#---------------------------------------------------------------------#


function registry_get_acl(key)
{

name = get_kb_item("SMB/name");
if(!name)exit(0);


domain = get_kb_item("SMB/workgroup");

if(!get_port_state(139))return(FALSE);

login = get_kb_item("SMB/login");
pass  = get_kb_item("SMB/password");

if(!login)login = "";
if(!pass) pass = "";

	  
soc = open_sock_tcp(139);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:name);
if(!r)return(FALSE);

#
# Negociate the protocol
#
if(!smb_neg_prot(soc:soc))return(FALSE);

#
# Set up our session
#
r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain);
if(!r)return(FALSE);
# and extract our uid
uid = session_extract_uid(reply:r);

#
# Connect to the remote IPC and extract the TID
# we are attributed
#      
r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
# and extract our tree id
tid = tconx_extract_tid(reply:r);


#
# Create a pipe to \winreg
#
r = smbntcreatex(soc:soc, uid:uid, tid:tid);
if(!r)return(FALSE);
# and extract its ID
pipe = smbntcreatex_extract_pipe(reply:r);

#
# Setup things
#
r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r)return(FALSE);
r = registry_access_step_1(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(strlen(key))
{
r2 = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:r);
}
else r2 = r;

if(r2)
 {
 r3 =  registry_get_key_security(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:r2);
#mss testing
 close(soc);
 if(strlen(r3) < 150)return(TRUE);
 }
return(FALSE);
}

#---------------------------------------------------------------------#
# Get an item of type reg_sz from the key                             #
#---------------------------------------------------------------------#

function unicode2(data)
{
 len = strlen(data);
 ret = raw_string(0, ord(data[0]));
 
 for(i=1;i<len;i=i+1)
 {
  ret = ret + raw_string(0, ord(data[i]));
 }
 if(len & 1)ret = ret + raw_string(0x00, 0x00); 
 else ret = ret + raw_string(0x00, 0x00, 0x00, 0x63);
 return(ret);
}


function registry_get_item_sz(soc, uid, tid, pipe, item, reply)
{
 item_len = strlen(item) + 1;
 item_len_lo = item_len % 256;
 item_len_hi = item_len / 256;
 
 uc2 = unicode2(data:item);
 len = 188 + strlen(uc2);
 len_lo = len % 256;
 len_hi = len / 256;
 
 tid_low = tid % 256;
 tid_high = tid / 256;
 uid_low = uid % 256;
 uid_high = uid / 256;
 pipe_low = pipe % 256;
 pipe_high = pipe / 256;
 
 bcc = 121 + strlen(uc2);
 bcc_lo = bcc % 256;
 bcc_hi = bcc / 256;
 
 y = 80 + strlen(uc2);
 y_lo = y % 256;
 y_hi = y / 256;
 
 z = 104 + strlen(uc2);
 z_lo = z % 256;
 z_hi = z / 256;
 req = raw_string(0x00, 0x00,
 		  len_hi, len_lo, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x03, 0x80, 0x1D, 0x83,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_low, tid_high, 0x00, 0x28, uid_low, uid_high,
		  0x00, 0x00, 0x10, 0x00, 0x00, z_lo, z_hi, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, z_lo, z_hi, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_low, pipe_high, bcc_lo, bcc_hi, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, z_lo, z_hi,
		  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, y_lo, y_hi,
		  0x00, 0x00, 0x00, 0x00, 0x11, 0x00);
		  
 magic = raw_string(ord(reply[84]));
 for(i=1;i<20;i=i+1)
 {
  magic = magic + raw_string(ord(reply[84+i]));
 }

 x = 2 + strlen(item) + strlen(item);
 x_lo = x % 256;
 x_hi = x / 256;
  
 y = y + 3;
 y_lo = y % 256;
 y_hi = y / 256;
 
  req = req + magic + raw_string(x_lo, x_hi, 0x0A, 0x02, 0x00, 0xEC,
  		0xFD, 0x7F, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, item_len_lo, item_len_hi, 0x00)
		
		+ uc2	+ 
		raw_string(0x00, 0x34, 0xFF,
		0x12, 0x00, 0xEF, 0x10, 0x40, 0x00, 0x18, 0x1E,
		0x7c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xFF,
		0x12, 0x00, 0x00, 0x04, 0x00, 0x00, 0x30, 0xFF,
		0x12, 0x00, 0x00, 0x00, 0x00, 0x00);
		
 send(socket:soc, data:req);
 req = smb_recv(socket:soc, length:4000);		
 return(req);
}		  

#------------------------------------------------------#
# Decode the reply from the registry                   #
#------------------------------------------------------#

function registry_decode_sz(data)
{
 len = ord(data[2])*256;
 len = len + ord(data[3]);
 if(len < 130)return(FALSE);
 
 data_offset = ord(data[52])*256;
 data_offset = data_offset + ord(data[51]) + 4;
 data_len = ord(data[data_offset+43]);
 data_len = data_len * 256;
 data_len = data_len + ord(data[data_offset+44]);
 index = data_offset + 48;
 o = "";
 data_len = data_len - 2;
 
 for(i=0;i<data_len;i=i+2)
 {
   o = string(o, raw_string(ord(data[index+i])));
 }
 return(o);
}
			  
		 
#---------------------------------------------------------------------#
# registry_get_sz()						      #
#---------------------------------------------------------------------#


function registry_get_sz(key, item)
{

name = get_kb_item("SMB/name");
if(!name)exit(0);


if(!get_port_state(139))return(FALSE);

login = get_kb_item("SMB/login");
pass  = get_kb_item("SMB/password");

domain = get_kb_item("SMB/workgroup");

if(!login)login = "";
if(!pass) pass = "";

	  
soc = open_sock_tcp(139);

#
# Request the session
# 
r = smb_session_request(soc:soc,  remote:name);
if(!r)return(FALSE);

#
# Negociate the protocol
#
if(!smb_neg_prot(soc:soc))return(FALSE);

#
# Set up our session
#
r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain);
if(!r)return(FALSE);
# and extract our uid
uid = session_extract_uid(reply:r);

#
# Connect to the remote IPC and extract the TID
# we are attributed
#      
r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
# and extract our tree id
tid = tconx_extract_tid(reply:r);


#
# Create a pipe to \winreg
#
r = smbntcreatex(soc:soc, uid:uid, tid:tid);
if(!r)return(FALSE);
# and extract its ID
pipe = smbntcreatex_extract_pipe(reply:r);

#
# Setup things
#
r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
if(!r)return(FALSE);
r = registry_access_step_1(soc:soc, uid:uid, tid:tid, pipe:pipe);

r2 = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:r);
if(r2)
{
 r3 =  registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:r2);
 value = registry_decode_sz(data:r3);
#mss testing
 close(soc);
 return(value);
}
return(FALSE);
}

#---------------------------------------------------------------------------#
# SAM related functions							    #
#---------------------------------------------------------------------------#

#------------------------------------------------------#
# Open a pipe to \samr                                 #
#------------------------------------------------------#
function OpenPipeToSamr(soc, uid, tid)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x60, 0xFF, 0x53, 0x4D, 0x42, 0xA2, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x18, 0xFF, 0x00, 0xDE, 0xDE, 0x00,
		  0x0A, 0x00, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 
		  0x00, 0x00, 0x9F, 0x01, 0x02, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00,
		  0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x02, 0x00,
		  0x00, 0x00, 0x03, 0x0D, 0x00, 0x00, 0x5C, 0x00,
		  0x73, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x72, 0x00,
		  0x00, 0x00);
		  
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 42) return(FALSE);
 else {
 	low = ord(r[42]);
	hi  = ord(r[43]);
	ret = hi * 256;
	ret = ret + low;
	return(ret);
      }
}

function samr_smbwritex(soc, tid, uid, pipe)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x88, 0xFF, 0x53, 0x4D, 0x42, 0x2F, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x0E, 0xFF, 0x00, 0xDE, 0xDE, pipe_lo,
		  pipe_hi, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
		  0xFF, 0x08, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48,
		  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49,
		  0x00, 0xEE, 0x05, 0x00, 0x0B, 0x03, 0x10, 0x00,
		  0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00,
		  0x00, 0x00, 0xB8, 0x10, 0xB8, 0x10, 0x00, 0x00,
		  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x01, 0x00, 0x78, 0x57, 0x34, 0x12, 0x34, 0x12,
		  0xCD, 0xAB, 0xEF, 0x00, 0x01, 0x23, 0x45, 0x67,
		  0x89, 0xAC, 0x01, 0x00, 0x00, 0x00, 0x04, 0x5D,
		  0x88, 0x8A, 0xEB, 0x1C, 0xC9, 0x11, 0x9F, 0xE8,
		  0x08, 0x00, 0x2B, 0x10, 0x48, 0x60, 0x02, 0x00,
		  0x00, 0x00);
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
}		


function samr_smbreadx(soc, tid, uid, pipe)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 req = raw_string(0x00, 0x00,
 		  0x00, 0x3B, 0xFF, 0x53, 0x4D, 0x42, 0x2E, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x0C, 0xFF, 0x00, 0xDE, 0xDE, pipe_lo,
	       pipe_hi, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
		  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 0x00, 
		  0x00, 0x00, 0x00, 0x00, 0x00);
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);

}		    

#------------------------------------------------------#
# Returns the unicode representation of <name>         #
#------------------------------------------------------#
function samr_uc(name)
{
 ret = "";
 for(i=0;i<strlen(name);i=i+1)
 {
  ret = ret + raw_string(0) + name[i];
 }
 return(ret);
}



#------------------------------------------------------#
# Connects to the remote SAM                           #
#------------------------------------------------------#
function SamrConnect2(soc, tid, uid, pipe, name)
{
 samr_smbwritex(soc:soc, tid:tid, uid:uid, pipe:pipe);
 samr_smbreadx(soc:soc, tid:tid, uid:uid, pipe:pipe);
 
 l = strlen(name);
 odd = l % 2;
 
 if(odd)p = 0;
 else p = 2;
 
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 
 l = 3 + strlen(name);
 l_h = l / 256;
 l_l = l % 256;
 

 tot_len = 134 + strlen(name) + strlen(name) + p;
 tot_len_h = tot_len / 256;
 tot_len_l = tot_len % 256;
 
 bcc = 67 + strlen(name) + strlen(name) + p;
 bcc_lo = bcc % 256;
 bcc_hi = bcc / 256;
 
 total_data_count = 50 + strlen(name) + strlen(name) + p;
 total_data_count_lo = total_data_count % 256;
 total_data_count_hi = total_data_count / 256;
 
 req = raw_string(0x00, 0x00,
 		  tot_len_h, tot_len_l, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00,total_data_count_lo, total_data_count_hi, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, total_data_count_lo, total_data_count_hi, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, bcc_lo, bcc_hi, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0xAF, 0x47, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, total_data_count_lo, total_data_count_hi,
		  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x28, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x39, 0x00, 0x60, 0x60,
		  0x13, 0x00, l_l, l_h, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, l_l, l_h, 0x00, 0x00, 0x5C, 0x00,
		  0x5C) + samr_uc(name:name) + raw_string(0x00, 0x00, 0x00);
		  
  if(p)req = req + raw_string(0xC9, 0x11); # 0x02, 0x00, 0x00, 0x00);
  
  req = req +  raw_string(0x30, 0x00, 0x00, 0x00);
 #display(strlen(req), "\n");		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);		  
 #display("--->", strlen(r), "\n");
 #
 # We return a handle to the remote SAM
 #		  
 
 samrhdl = "";
 _len = strlen(r);
 if(_len < 24)
 	return(FALSE);
	
 _len = _len - 24;
 for(i=0;i<20;i=i+1)
 {
  samrhdl = samrhdl + raw_string(ord(r[i+_len]));
  #display(hex(ord(r[i+_len])), " ");
 }
 #display("\n");
 #display("samhdl : ", strlen(samrhdl), "\n");
 return(samrhdl);
}


#--------------------------------------------------------------#
# This function is probably SamrEnumerateDomainsInSamServer()  #
# but I'm not sure of that, so I changed its name to           #
# _SamrEnumDomains()                                           #
#                                                              #
# This function only returns the first domain it obtains       #
#--------------------------------------------------------------#
function _SamrEnumDomains(soc, uid, tid, pipe, samrhdl)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x88, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x34, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x34, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x45, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0xAF, 0x47, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x34, 0x00,
		  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x1C, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x06, 0x00) + samrhdl +
	raw_string(0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
		  0x00, 0x00);
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);		  
 if(strlen(r) < 137)return(FALSE);
 
 len_lo = ord(r[136]);
 len_hi = ord(r[137]);
 
 len = len_hi * 256;
 len = len + len_lo;
 dom = "";
 len = len*2;
 for(i=0;i<len;i=i+2)
 {
  dom = dom + raw_string(ord(r[139+i]), ord(r[140+i]));
 }
 #display(dom, "\n");
 return(dom);  
}


#------------------------------------------------------#
# Returns the sid from the domain <dom>                #
#------------------------------------------------------#

function SamrDom2Sid(soc, tid, uid, pipe, samrhdl, dom)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 #display(strlen(dom), "<-dom\n");
 tot_len = 148 + strlen(dom);
 tot_len_hi = tot_len / 256;
 tot_len_lo = tot_len % 256;
 
 bcc = 81 + strlen(dom);
 bcc_lo = bcc % 256;
 bcc_hi = bcc / 256;
 
 tot_dat_count = 64 + strlen(dom);
 tot_dat_count_lo = tot_dat_count % 256;
 tot_dat_count_hi = tot_dat_count / 256;
 
 dom_len = strlen(dom);
 dom_len = dom_len / 2;
 dom_len_lo = dom_len % 256;
 dom_len_hi = dom_len / 256;
  
 dom_t_len =  dom_len + 1;
 dom_t_len_lo = dom_t_len % 256;
 dom_t_len_hi = dom_t_len / 256;
 
 dom_m_len = dom_len * 2;
 dom_m_len_lo = dom_m_len % 256;
 dom_m_len_hi = dom_m_len / 256;
 
 dom_mm_len = dom_m_len + 2;
 dom_mm_len_lo = dom_mm_len % 256;
 dom_mm_len_hi = dom_mm_len / 256;
 
 
 req = raw_string(0x00, 0x00,
 		 tot_len_hi, tot_len_lo, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		 0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		 0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		 0x00, 0x00, 0x10, 0x00, 0x00, tot_dat_count_lo, tot_dat_count_hi, 0x00,
		 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		 0x00, tot_dat_count_lo, tot_dat_count_hi, 0x54, 0x00, 0x02, 0x00, 0x26,
		 0x00, pipe_lo, pipe_hi, bcc_lo, bcc_hi, 0x00, 0x5C, 0x00,
		 0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		 0x5C, 0x00, 0x00, 0x00, 0xAF, 0x47, 0x05, 0x00,
		 0x00, 0x03, 0x10, 0x00, 0x00, 0x00, tot_dat_count_lo, tot_dat_count_hi,
		 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x38, 0x00,
		 0x00, 0x00, 0x00, 0x00, 0x05, 0x00) + samrhdl + 
   raw_string(	 dom_m_len_lo, dom_m_len_hi, dom_mm_len_lo, dom_mm_len_hi, 0x40, 0x7B,
   		 0x13, 0x00, dom_t_len_lo, dom_t_len_hi, 0x00, 0x00, 0x00, 0x00,
		 0x00, 0x00, dom_len_lo, dom_len_hi, 0x00) + dom + raw_string(0x00);
		 
  send(socket:soc, data:req);
  r = smb_recv(socket:soc, length:4096);
  if(strlen(r) < 88)return(FALSE);
  #display(ord(r[88]), "\n");  
  
  _sid = "";
  
  for(i=0;i<28;i=i+1)
  {
   _sid = _sid + raw_string(ord(r[88+i]));
   #display(hex(ord(r[88+i])),  " ");
  }
  #display("\n");
  return(_sid);
}


#------------------------------------------------------#
# Opens a policy handle to a given domain              #
#------------------------------------------------------#
function SamrOpenDomain(soc, tid, uid, pipe, samrhdl, sid)
{

 #display("sid = ", strlen(sid), "\n");
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 
 len = 132 + strlen(sid);
 len_h = len / 256;
 len_l = len % 256;

 tdc = 48 + strlen(sid);
 tdc_l = tdc % 256;
 tdc_h = tdc / 256;
 
 bcc = tdc + 17;
 bcc_l = bcc % 256;
 bcc_h = bcc / 256;
 req = raw_string(0x00, 0x00,
 		  0x00, 0xA0, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x4C, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x4C, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x5D, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x33, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x4C, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x34, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x07, 0x00) + samrhdl +
	raw_string(0x00, 0x02, 0x00, 0x00) + sid;
		  
		  
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 30)
 	return(FALSE);
	
 #display(strlen(r),"\n");
 samrhdl = "";
 _len = strlen(r);
 _len = _len - 24;
 _z = 0;
 for(i=0;i<20;i=i+1)
 {
  if(ord(r[i+_len]) == 0)_z = _z + 1;
  samrhdl = samrhdl + raw_string(ord(r[i+_len]));
  #display(hex(ord(r[i+_len])), " ");
 }
 #display("\n");
 #display("samhdl : ", strlen(samrhdl), "\n");
 if(_z == 20)return(0);
 
 return(samrhdl);
}		  


function SamrOpenBuiltin(soc, tid, uid, pipe, samrhdl)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;

 req = raw_string(0x00, 0x00,
 		  0x00, 0x94, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x80, 0x03, 0x10, 0x00, 0x00, 0x40, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x40, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x51, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x40, 0x00,
		  0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x28, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x07, 0x00) + samrhdl +
       raw_string(            0x80, 0x02, 0x00, 0x00, 0x01, 0x00,
       		  0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x05, 0x20, 0x00, 0x00, 0x00);
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 builtinhdl = "";
 _len = strlen(r);
 _len = _len - 24;
 _z  = 0;
 for(i=0;i<20;i=i+1)
 { 
  if(ord(r[i+_len]) == 0)_z = _z + 1;
  builtinhdl = builtinhdl + raw_string(ord(r[i+_len]));
  #display(hex(ord(r[i+_len])), " ");
 }
 if(_z == 20)return(0);
#display("\n");
#display("builtinhdl : ", strlen(builtinhdl), "\n");
 return(builtinhdl);
 
 		  
}


#------------------------------------------------------#
# Converts a username to its rid                       #
#------------------------------------------------------#
function SamrLookupNames(soc, uid, tid, name, domhdl)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 usr = samr_uc(name:name);
 len = 164 + strlen(usr);
 len_hi = len / 256;
 len_lo = len % 256;

 
 
 tdc = 80 + strlen(usr);
 tdc_l = tdc % 256;
 tdc_h = tdc / 256;
 
 bcc = tdc + 17;
 bcc_l = bcc % 256;
 bcc_h = bcc / 256;
 
 x = strlen(usr) / 2;
 x_h = x / 256;
 x_l = x % 256;
 
 y = x + 1;
 y_h = y / 256;
 y_l = y % 256;
 
 z = strlen(usr);
 z_l = z % 256;
 z_h = z / 256;
 
 t = z + 2;
 t_l = t % 256;
 t_h = t / 256;
 
 
 req = raw_string(0x00, 0x00, 
 		  len_hi, len_lo, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, tdc_l, tdc_h, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, tdc_l, tdc_h, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, bcc_l, bcc_h, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0xAF, 0x47, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, tdc_l, tdc_h,
		  0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x44, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x11, 0x00) + domhdl +
		  raw_string(0x01, 0x00, 0x00, 0x00, 0xE8, 0x03,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
		  0x00, 0x00, z_l, z_h, t_l, t_h, 0xD8, 0x0E, 
		  0x41, 0x00, y_l, y_h, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, x_l, x_h, 0x00) + usr + 
		  raw_string(0x00);
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);		
 
 if(strlen(r) < 96)return(FALSE);
 
 _rid = "";
##display("RID : ");
 _z = 0;
 for(i=0;i<4;i=i+1)
 {
  if(ord(r[96+i]) == 0)_z = _z + 1;
#  ##display(hex(ord(r[96+i])), " ");
  _rid = _rid + raw_string(ord(r[96+i]));
 }
##display("\n");
 if(_z == 4)return(0);
 
 return(_rid);
}

#--------------------------------------------------------#
# Opens a policy handle to a given user                  #
#--------------------------------------------------------#
function SamrOpenUser(soc, uid, tid, pipe, samhdl, rid)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 len = 176;
 len_hi = len / 256;
 len_lo = len % 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x88, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x34, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x34, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x45, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x33, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x34, 0x00,
		  0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x1c, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x22, 0x00) + samrhdl +
	raw_string(0x1B, 0x01, 0x02, 0x00) + rid;

 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 if(strlen(r) < 100)return(FALSE);
 
 _usrhdl = "";
 _len = strlen(r);
 _len = _len - 24;
 #display("usrhdl = ");
 _z = 0;
 for(i=0;i<20;i=i+1)
 {
  if(ord(r[i+_len]) == 0)_z = _z + 1;
  _usrhdl = _usrhdl + raw_string(ord(r[i+_len]));
  #display(hex(ord(r[i+_len])), " ");
 }
 
 if(_z == 20)return(0);
 
 #display("\n");
 return(_usrhdl);
}

#-------------------------------------------------------#
# Requests the list of groups to which the user belongs #
# to						        #
#-------------------------------------------------------#

function SamrQueryUserGroups(soc, uid, tid, pipe, usrhdl)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x80, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x2C, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x2C, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26, 
		  0x00, pipe_lo, pipe_hi, 0x3D, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x2C, 0x00,
		  0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x27, 0x00) + usrhdl;
		  
 send(socket:soc, data:req);
 r = recv(socket:soc, length:4096); 
 
 
 num_lo = ord(r[88]);
 num_hi = ord(r[89]);
 
 num = num_hi * 256;
 num = num + num_lo;
 
 #
 # Ok. Our user is in <num> groups. Let's decode their RID
 #
 
 if(strlen(r) < 100)
 	return(FALSE);
 base = 100;
 rids = "";
 for(i=0;i<num;i=i+1)
 {
  g_rid = string(hex(ord(r[base+3])), "-", 
  	       hex(ord(r[base+2])), "-",
	       hex(ord(r[base+1])), "-",
	       hex(ord(r[base])));
	   
  base = base + 8;
  rids = rids + g_rid + string("\n");
 }	
  return(rids);
}
#------------------------------------------------------#
# Queries information about a given user               #
#------------------------------------------------------#
function SamrQueryUserInfo(soc, uid, tid, pipe, usrhdl)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 req = raw_string(0x00, 0x00,
 		  0x00, 0x82, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x2E, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x2E, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x3F, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x33, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x2E, 0x00,
		  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x16, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x24, 0x00) + usrhdl +
		  raw_string(0x15, 0x00);
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 		  
 return(r);
}


#-------------------------------------------------------#
# Requests the list of aliases to which the user belongs #
# to						        #
#-------------------------------------------------------#


function SamrQueryUserAliases(soc, uid, tid, pipe, usrhdl, sid, rid)
{
 tid_hi = tid / 256;
 tid_lo = tid % 256;
 uid_hi = uid / 256;
 uid_lo = uid % 256;
 
 pipe_hi = pipe / 256;
 pipe_lo = pipe % 256;
 
 subsid = "";
 
 for(i=0;i<20;i=i+1)
 {
  subsid = subsid + raw_string(ord(sid[8+i]));
  #display(hex(ord(sid[8+i])), " ");
 }
 #display("\n");
 
 
 
 
 req = raw_string(0x00, 0x00, 
 		  0x00, 0xB0, 0xFF, 0x53, 0x4D, 0x42, 0x25, 0x00,
		  0x00, 0x00, 0x00, 0x18, 0x07, 0xC8, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, tid_lo, tid_hi, 0x00, 0x28, uid_lo, uid_hi,
		  0x00, 0x00, 0x10, 0x00, 0x00, 0x5C, 0x00, 0x00,
		  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54,
		  0x00, 0x5C, 0x00, 0x54, 0x00, 0x02, 0x00, 0x26,
		  0x00, pipe_lo, pipe_hi, 0x6D, 0x00, 0x00, 0x5C, 0x00,
		  0x50, 0x00, 0x49, 0x00, 0x50, 0x00, 0x45, 0x00,
		  0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
		  0x00, 0x03, 0x10, 0x00, 0x00, 0x00, 0x5C, 0x00,
		  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x44, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x10, 0x00) + usrhdl +
       raw_string(0x01, 0x00, 0x00, 0x00, 0x88, 0x7C,
       	 	  0x13, 0x00, 0x01, 0x00, 0x00, 0x00, 0x98, 0x7C,
		  0x13, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x05,
		  0x00, 0x00) + subsid + rid;
		  
 send(socket:soc, data:req);
 r = smb_recv(socket:soc, length:4096);
 
 if(strlen(r) < 100){
 	#display("=====>", strlen(r), "<====\n");
 	return(FALSE);
	}
 
 
 num_lo = ord(r[92]);
 num_hi = ord(r[93]);
 
 num = num_hi * 256;
 num = num + num_lo;
 #display("NUM EGAL : ", num, "\n");
 base = 96;
 rids = "";
 for(i=0;i<num;i=i+1)
 {
  _rid = string(hex(ord(r[base+3])), "-",
  		hex(ord(r[base+2])), "-",
		hex(ord(r[base+1])), "-",
		hex(ord(r[base])));
		
  rids = rids + _rid + string("\n");		
  base = base + 4;		
 }	  
 return(rids);
}		


function _ExtractTime(buffer, base)
{
 return(string(      hex(ord(buffer[base+7])), "-",
 		     hex(ord(buffer[base+6])), "-",
		     hex(ord(buffer[base+5])), "-",
		     hex(ord(buffer[base+4])), "-",
		     hex(ord(buffer[base+3])), "-",
		     hex(ord(buffer[base+2])), "-",
		     hex(ord(buffer[base+1])), "-",
		     hex(ord(buffer[base]))));
}

#------------------------------------------------------#
# Decodes the informations received about a given usr  #
# This function is not part of MSDN, hence the under-  #
# score in front of it                                 #
#------------------------------------------------------#

function _SamrDecodeUserInfo(info, count, type)
{
 lim = strlen(info);
 
 

 if(strlen(info) < 100)
 	return(FALSE);
	

 #
 # Various times
 #
 
 logon = _ExtractTime(buffer:info, base:92);
 #display("Logon time : ", logon, "\n");
 
 set_kb_item(name:string("SMB/", type, "/", count, "/Info/LogonTime"),
 	     value:logon);
	     
 
 logoff = _ExtractTime(buffer:info, base:100);
 #display("Logoff time : ", logoff, "\n");
  set_kb_item(name:string("SMB/", type, "/", count, "/Info/LogoffTime"),
 	     value:logoff);
 kickoff = _ExtractTime(buffer:info, base:108);
 #display("Kickoff time : ", kickoff, "\n");
  set_kb_item(name:string("SMB/", type, "/", count, "/Info/KickoffTime"),
 	     value:kickoff);
	     
 base = 116;
 pass_last_set = _ExtractTime(buffer:info, base:116);

 #display("Pass last set : ", pass_last_set, "\n");		     
 set_kb_item(name:string("SMB/", type, "/", count, "/Info/PassLastSet"),
 	     value:pass_last_set); 
	     
	     
 pass_can_change = _ExtractTime(buffer:info, base:124);
 #display("Pass can change : ", pass_can_change,"\n");
  set_kb_item(name:string("SMB/", type, "/", count, "/Info/PassCanChange"),
 	     value:pass_can_change);
 
 pass_must_change = _ExtractTime(buffer:info, base:132);
 
 #display("Pass must change : ", pass_must_change, "\n");
  set_kb_item(name:string("SMB/", type, "/", count, "/Info/PassMustChange"),
 	     value:pass_must_change);
 
 #
 # ACB
 #
 
 if(strlen(info) < 260)
 {
  return(0);
 }
 
 acb_lo = ord(info[260]);
 acb_hi = ord(info[261]);
 acb = acb_hi * 256;
 acb = acb + acb_lo;
 #display("ACB : ", hex(acb), "\n");
 
  set_kb_item(name:string("SMB/", type, "/", count, "/Info/ACB"),
 	     value:acb);
	     
	     
 #if(acb & 0x01)display("  Account is disabled\n");
 #if(acb & 0x04)display("  Password not required\n");
 #if(acb & 0x10)display("  Normal account\n");
 #if(acb & 0x0200)display("  Password does not expire\n");
 #if(acb & 0x0400)display("  Account auto-locked\n");
 #if(acb & 0x0800)display("  Password can't be changed\n");
  
 #if(acb & 0x1000)display("  Smart card is required for interactive log on\n");
 #if(acb & 0x2000)display("  Account is trusted for delegation\n");
 #if(acb & 0x4000)display("  Account is sensitive an can not be delegated\n");
 #if(acb & 0x8000)display("  Use DES encryption type for this account\n");
 
}

