
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10905);
 script_version("$Revision: 1.3 $");
 name["english"] = "Users in the 'Print Operator' group";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script displays the names of the users that
are in the 'Print Operator' group.

You should make sure that only the proper users
are member of this group.

Risk factor : Low";



 script_description(english:desc["english"]);
 
 summary["english"] = "Lists the users that are in special groups";

 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
 family["english"] = "Windows : User management";
 script_family(english:family["english"]);
 script_dependencies("smb_netusergetaliases.nasl");
 script_require_keys("SMB/Users/enumerated");
 exit(0);
}

report = "";
count = 1;
login = get_kb_item(string("SMB/Users/", count));
while(login)
{
 groups = get_kb_item(string("SMB/Users/", count, "/LocalGroups"));
 if(groups)
 {
  grp = string("0x00-0x00-0x02-0x26");
  if(grp >< groups)
  {
  report = report + string(". ", login, "\n");
  }
 }
 count = count + 1;
 login = get_kb_item(string("SMB/Users/", count));
}


if(strlen(report))
{
 data = 
 string("The following users are in the 'Print Operator' group :\n", report,
 "\n", "You should make sure that only the proper users are member of this
 group\n", "Risk factor : Low");
 
 security_note(port:139, data:data);
}
