#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10228);
 script_version ("$Revision: 1.10 $");
 script_cve_id("CVE-1999-0626");
 
 name["english"] = "rusersd service";
 name["francais"] = "Service rusersd";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The rusersd RPC service is running. 
It provides an attacker interesting
information such as how often the
system is being used, the names of
the users, and so on.
	
It usually not a good idea to leave this
service open.


Risk factor : Low";


 desc["francais"] = "
Le service RPC rusersd tourne.
Il donne  un pirate des informations
sensibles telles que le taux d'usage
du systme et le nom des utilisateurs.
	
C'est gnrallement une mauvaise
ide que de laisser ce service ouvert.

Facteur de risque : Faible";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks the presence of a RPC service";
 summary["francais"] = "Vrifie la prsence d'un service RPC";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "RPC"; 
 family["francais"] = "RPC";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("rpc_portmap.nasl");
 script_require_keys("rpc/portmap");
 exit(0);
}

#
# The script code starts here
#


#
# If the portmapper is not installed, then
# just exit
#
portmap = get_kb_item("rpc/portmap");
if(!portmap)exit(0);



RPC_PROG = 100002;
tcp = 0;
port = getrpcport(program:RPC_PROG, protocol:IPPROTO_UDP);
if(!port){
	port = getrpcport(program:RPC_PROG, protocol:IPPROTO_TCP);
	tcp = 1;
	}

if(port)
{
 if(tcp)security_warning(port);
 else security_warning(port, protocol:"udp");
}
