#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10205);
 script_version ("$Revision: 1.11 $");
 script_cve_id("CAN-1999-0651");
 name["english"] = "rlogin";
 name["francais"] = "rlogin";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The rlogin service is running.
This service is dangerous in the sense that
it is not ciphered - that is, everyone can sniff
the data that passes between the rlogin client
and the rlogin server. This includes logins
and passwords.

You should disable this service and use openssh instead
(www.openssh.com)

Solution : Comment out the 'rlogin' line in /etc/inetd.conf.

Risk factor : Low";


 desc["francais"] = "Le service rlogin tourne.
Ce service est dangereux dans le sens o la communication
entre le serveur et le client n'est pas chiffre, 
ce qui permet  n'importe qui de sniffer les donnes
qui passent entre le client et le serveur - ce qui
inclut les noms d'utilisateurs et leur mot de passe.

Vous devriez dsactiver ce service et utiliser
openssh  la place (www.openssh.com)

Solution : dsactivez ce service dans /etc/inetd.conf.

Facteur de risque : Faible";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of rlogin";
 summary["francais"] = "Vrifie la prsence du service rlogin";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Useless services";
 family["francais"] = "Services inutiles";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/rlogin", 513);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/rlogin");
if(!port)port = 513;

if(get_port_state(port))
{
 soc = open_priv_sock_tcp(dport:port);
 if(soc)
 {
  s1 = raw_string(0);
  s2 = "root" + raw_string(0) + "root" + raw_string(0) + "ls" + raw_string(0);
  send(socket:soc, data:s1);
  send(socket:soc, data:s2);
  a = recv(socket:soc, length:1024);
  if(strlen(a))
   security_warning(port);
  else
   {
   a = recv(socket:soc, length:1024);
   if(strlen(a))
    security_warning(port);
   } 
  close(soc);
 }
}

