#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10879);
 script_version("$Revision: 1.5 $");
 name["english"] = "Shell Command Execution Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote port seems to be running some form of shell script,
with some provided user input. The input is not stripped for such meta 
characters as ` ' | , etc. This would allow a remote attacker to cause it to 
execute arbitrary code.

Solution : Make sure all meta characters are filtered out, or close the port 
for access from untrusted networks

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the filtering if dangerous meta characters from network binded scripts";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");

 family["english"] = "Gain a shell remotely";

 script_family(english:family["english"]);
 script_dependencie("nmap_wrapper.nes");
 exit(0);
}

#
# The script code starts here
#

function test_port(port, command)
{
  soc = open_sock_tcp(port);
  if(soc)
  {
   data = string("`", command, "` #\n");
   send(socket:soc, data:data);
 
   buf = recv(socket:soc, length:65535);
   looking_for = string("uid=");

   if (looking_for >< buf)
   {
    security_hole(port);
    return(1);
   }

   close(soc);
  }
 }


function test_for_backtick(port)
{
  soc = open_sock_tcp(port);
  if(soc)
  {
   data = string("`\n");
   send(socket:soc, data:data);

   buf = recv(socket:soc, length:65535);

   looking_for = string("sh: unexpected EOF while looking for ");
   looking_for_2 = raw_string(0x60, 0x60, 0x27);

   looking_for = string(looking_for, looking_for_2);
   if (looking_for >< buf)
   {
    security_hole(port);
    return(1);
   }

   close(soc);
  }
}

i =  0;
port = scanner_get_port(i);
while(port)
{
 if(get_port_state(port))
 {
   test_for_backtick(port:port);
   test_port(port:port, command:"/bin/id"))	
    	exit(0);
  test_port(port:port, command:"/usr/bin/id");
 }
 i = i + 1;
 port = scanner_get_port(i);
}


