#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10808);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CAN-2002-0102");
 
 name["english"] = "DoSable Oracle WebCache server";
 script_name(english:name["english"]);
 desc["english"] = "
There is a bug in the remote version of OracleWebCache
which allows any attacker to disable this service 
remotely.

An attacker may use this flaw to prevent outsiders from
accessing your website.

Solution: Contact your vendor for the latest software release.

*** Note that Nessus solely relied on the version number of the remote
*** service to issue this warning

Risk factor : Medium";
 script_description(english:desc["english"]);
 summary["english"] = "Determines via ver. the remote server can be disabled";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");
 script_dependencies("find_service.nes", "proxy_use.nasl");
 script_require_ports("Services/http_proxy", 8080, 3128);
 exit(0);
}

#
# Code Starts Here
#

port = get_kb_item("Services/www");
if(!port)port = 1100;
if(!get_port_state(port))port = 4000;
if(!get_port_state(port))port = 4001;
if(!get_port_state(port))port = 4002;


if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  req = http_get(item:"/", port:port);
  send(socket:soc, data:req);
  data = recv(socket:soc, length:1024);
  data = egrep(pattern: "^Server: ", string: data);
  if(ereg(pattern:".*Oracle9iAS Web Cache/2\.0\.0\.[12].*",
	  string:data))security_hole(port);
 }
}
