#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10386);
 script_version ("$Revision: 1.20 $");

 name["english"] = "No 404 check";
 name["francais"] = "No 404 check";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
Some web servers are [mis]configured in that they
do not return '404 Not Found' error codes when
a non-existent file is requested, perhaps returning
a site map or search page instead.

This script will retrieve the default page which
is issued when a non-existent file is requested, and
will use this information to minimize the risks 
of false positives for the other tests.

Risk factor : None";

 desc["francais"] = "
Certains serveurs web n'affichent pas d'erreur 404
lorsqu'un client leur demande une page qui n'existe
pas.

Ce script rcupre donc la page d'erreur qui est
affiche et la garde en mmoire afin de pouvoir
minimiser par la suite les risques d'erreur
dus a ce comportement";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks if the remote webserver issues 404 errors";
 summary["francais"] = "Vrifie que le serveur web distant sort des erreurs 404";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = string("nessus_is_probing_this_host_", rand());
port = is_cgi_installed(cgi);

if(port)
{
 soc = http_open_socket(port);
 if(soc)
 {

# -- perform first get --

  req = http_get(item:string("/cgi-bin/nessus_is_probing_you_",rand()), port:port);
  send(socket:soc, data:req);
  http_recv_headers(soc);
  r = recv(socket:soc, length:4096);
  close(soc);

  grep11 = egrep(pattern:"title",string:r, icase:TRUE);
  grep12 = egrep(pattern:"not found",string:r, icase:TRUE);
  grep13 = egrep(pattern:"404",string:r);

# -- perform second get --

  soc = open_sock_tcp(port);
  req = http_get(item:string("/nessus_is_probing_you_two_",rand()), port:port);
  send(socket:soc, data:req);
  http_recv_headers(soc);
  r2 = recv(socket:soc, length:4096);
  close(soc);

   grep21 = egrep(pattern:"title",string:r2, icase:TRUE);
   grep22 = egrep(pattern:"not found",string:r2, icase:TRUE);
   grep23 = egrep(pattern:"404",string:r2, icase:TRUE);

# -- decide to use the pattern or revert to default no404.nasl --



if (grep11)      # Check if title is common : lowest priority
 {r = grep21;}

if(grep12)
{
if (grep12==grep22) # Check 'not found' occurs in the body
 {r = grep22;}
}

if(grep13 )
{
if (grep13==grep23) # Check for line containing '404': highest priority
 {r = grep23;}
}

 # the default case is that r retains its value
 # reverting to the original no404.nasl


# -- set 'r' in the knowledge base --


  name = string("www/no404/", port);
  set_kb_item(name:name, value:r);

  report = string(
"The remote web server does not respect the HTTP protocol in that\n",
"it does not send 404 error codes when a client requests a non-existent\n",
"page.\nYou are very likely to get false positives for the web checks.\n");
  security_note(data:report, port:port);
#  close(soc);
 
 }
}
