#
# This script was written by Thomas Reinke <reinke@securityspace.com>,
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10947);
 script_cve_id("CAN-2002-0185");
 script_version("$Revision: 1.1 $");
 
 name["english"] = "mod_python handle abuse";

 script_name(english:name["english"]]);
 
 desc["english"] = "
The remote host is using the Apache mod_python module which
is version 2.7.6 or older.

These versions allow a module which is indirectly imported
by a published module to then be accessed via the publisher,
which allows remote attackers to call possibly
dangerous functions from the imported module. 

Solution : Upgrade to a newer version.
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for version of Python";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Thomas Reinke");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 key = string("www/banner/", port);
 banner = get_kb_item(key);
 if(!banner)
 {
   soc = open_sock_tcp(port);
   req = http_get(item:"/", port:port);
   send(socket:soc, data:req);
   banner = recv(socket:soc, length:2000);
   close(soc);
 }

 serv = strstr(banner, "Server");
 if(ereg(pattern:".*mod_python/(1.*|2\.([0-6]\..*|7\.[0-6])).*", string:serv))
 {
   security_hole(port);
 }
}
