#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10759);
 script_cve_id("CAN-2000-0649");
 script_version ("$Revision: 1.5 $");
 name["english"] = "Content-Location HTTP Header";
 script_name(english:name["english"]);
 
 desc["english"] = "
Asking the main page, a Content-Location header was added to the response.
By default, in Internet Information Server (IIS) 4.0,
the Content-Location references the IP address of the server
rather than the Fully Qualified Domain Name (FQDN) or Hostname.

This header may expose internal IP addresses that are usually hidden or masked
behind a Network Address Translation (NAT) Firewall or proxy server.

Solution: See http://support.microsoft.com/support/kb/articles/Q218/1/80.ASP

Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if the NAT expose internal IP address";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/iis");
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
banner = get_kb_item(string("www/banner/", port));
if(!banner)
{
 if(get_port_state(port))
 {
  soc = open_sock_tcp(port);
  if(soc)
  {
   req = http_get(item:"/", port:port);
   send(socket:soc, data:req);
   banner = recv(socket:soc, length:1024);
   close(soc);
  }
 }
}

if(banner)
{
 content_location = ereg_replace(pattern:".*Content-Location: http:\/\/([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})[^0-9].*",
			string:banner,
			replace:"\1");

 if (content_location)
 {
# Class A 10.*.*.* private network
# Class B 172.16-31.*.* private network
# Class C 192.168.*.* private network
  if (egrep(pattern:"10\..*",string:content_location) || egrep(pattern:"192\.168\..*",string:content_location) || egrep(pattern:"172\.(1[6-9]|2[0-9]|3[0-1])\..*",string:content_location))
  {
   security_warning(port);
   security_note(port:port, data:string("The address in Content-Location is: ", content_location));
  }
 }
}
