#
# Copyright 2002 by John Lampe...j_lampe@bellsouth.net
# thanks for signatures and packet dumps from Matt N., William Craig, and Bill King
#
# See the Nessus Scripts License for details
#
#

desc["english"] = "
We detected a Wireless Access Point 
You should ensure that the proper physical and logical controls exist around the AP

Risk factor : Medium/Low";



if(description)
{
 script_id(11026);
 script_version ("$Revision: 1.1 $");

 name["english"] = "Access Point detection";
 script_name(english:name["english"]);

 
 script_description(english:desc["english"]);

 summary["english"] = "Detect Access Point";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2002 John Lampe...j_lampe@bellsouth.net");
 family["english"] = "General";
 script_family(english:family["english"]);
 exit(0);
}

#
# The script code starts here
#

# try to find APs via web management interface 
port = 80;
pos[0] = "WLAN";    # SMC

soc = open_sock_tcp(port);
 if(soc) {
  send(socket:soc, data:string("GET / HTTP/1.0\r\n\r\n"));
  answer = recv(socket:soc, length:500);
  close(soc);
  if (answer) {
    for (i=0; pos[i]; i = i + 1) {
          if ((egrep(pattern:pos[i], string:answer))) { 
              security_note(port:port, protocol:"tcp");
          }
    }
  }
}



# try to find APs via snmp port (rely on them leaving public community string)
port = 161;

# put char string identifiers below 
snmppos[0]="AP-";                     # Compaq AP 



# create GET sysdescr call
snmpobjid = raw_string(0x2b,0x06,0x01,0x02,0x01,0x01,0x01,0x00);              #sysdescr
version = raw_string(0x02 , 0x01 , 0x00);
community = raw_string(0x04, 0x06) + "public";
pdu_type = raw_string(0xa0, 0x19);               
request_id = raw_string(0x02,0x01,0xde);
error_stat = raw_string(0x02,0x01,0x00);
error_index = raw_string(0x02,0x01,0x00);
tie_off = raw_string(0x05,0x00);


snmpstring = raw_string(0x30,0x26) + version + community + pdu_type + request_id + error_stat + error_index + raw_string(0x30,0x0e,0x30,0x0c,0x06,0x08) + snmpobjid + tie_off;
filter = string("udp and src host ", get_host_ip(), " and dst host " , this_host(), " and src port ", port);
UDP_LEN = strlen(snmpstring) + 8;


ip = forge_ip_packet(ip_v : 4,
                       ip_hl : 5,
                       ip_tos : 0,
                       ip_len : 20,
                       ip_id : 0xDEAD,
                       ip_p : IPPROTO_UDP,
                       ip_ttl : 255,
                       ip_off : 0,
                       ip_src : this_host(),
                       ip_dst : get_host_ip());


udpip = forge_udp_packet(                        ip : ip,
                                                 uh_sport : rand() % 65535,
                                                 uh_dport : port,
                                                 uh_ulen : UDP_LEN,
                                                 data : snmpstring);

result_suc = send_packet(udpip, pcap_active:TRUE, pcap_filter:filter);


flag = 0;
if (result_suc) {
    mydata = get_udp_element(udp:result_suc, element:"data");
    for (psi=0; snmppos[psi]; psi = psi + 1) {
        snmppos2 = snmppos[psi];
        for (mu=0; mu < strlen(mydata); mu = mu + 1) {
	    for (delta=0; delta < strlen(snmppos2); delta = delta + 1) {
                if (snmppos2[delta] == mydata[mu + delta]) {flag = flag + 1;}
	    }
	    if (flag == strlen(snmppos2)) {security_note(port:port, protocol:"udp");}
	    flag = 0;
	}
    }
}


















