#
# This script was written by Michel Arboi <arboi@bigfoot.com>
# starting from guild_ftp.nasl
#
# See the Nessus Scripts License for details
#

if(description)
{
  script_id(10933);
  script_version("$Revision: 1.4 $");
 name["english"] = "EFTP tells if a given file exists";
 name["francais"] = "EFTP indique si un fichier existe";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote FTP server can be used to determine if a given
file exists on the remote host or not, by adding dot-dot-slashes
in front of them. 

For instance, it is possible to determine the presence
of \autoexec.bat by using the command SIZE or MDTM on
../../../../autoexec.bat

An attacker may use this flaw to gain more knowledge about
this host, such as its file layout. This flaw is specially
useful when used with other vulnerabilities.

Solution : update your EFTP server to 2.0.8.348 or change it
Risk factor : Low";
 


 desc["francais"] = "
Le serveur FTP distant peut tre utilis pour determiner
si un fichier donn existe ou non, en ajoutant des
../ devant son nom.

Par exemple, il est possible de determiner la prsence
de \autoexec.bat en utilisant les commandes SIZE ou 
MDTM sur ../../../../autoexec.bat

Un pirate peut utiliser ce problme pour obtenir
plus d'informations sur ce systme, comme la hirarchie
de fichiers mise en place. Ce problme est d'autant plus
utile qu'il peut faciliter la mise en oeuvre de l'exploitation
d'autres vulnrabilits.

Solution : mettez votre serveur EFTP  jour en 2.0.8.348
ou changez-en
Facteur de risque : Faible";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "EFTP directory traversal";
 summary["francais"] = "EFTP directory traversal";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Michel Arboi",
		francais:"Ce script est Copyright (C) 2001 Michel Arboi");
 # family["english"] = "FTP";
 # family["francais"] = "FTP";
 family["english"] = "Untested";
 family["francais"] = "Untested";

 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "ftp_anonymous.nasl");
 script_require_ports("Services/ftp", 21);
 script_require_keys("ftp/login");
 exit(0);
}

#

cmd[0] = "SIZE";
cmd[1] = "MDTM";

port = get_kb_item("Services/ftp");
if(!port)port = 21;
login = get_kb_item("ftp/login");
pass  = get_kb_item("ftp/password");
# login = "ftp"; pass = "test@test.com";

if(get_port_state(port))
{
 vuln=0; tested=0;
 soc = open_sock_tcp(port);
 if(soc)
 {
  if(login)
  {
   if(ftp_log_in(socket:soc, user:login, pass:pass))
   {
    tested=tested+1;
    for (i = 0; cmd[i]; i = i + 1)
    {
     req = string(cmd[i], " ../../../../../../autoexec.bat\r\n");
     send(socket:soc, data:req);
     r = recv(socket:soc, length:4096);
     if("230 " >< r) vuln=vuln+1;
    }
   }
   else
   {
    # We could not log in ou could not download autoexec.
    # We'll just attempt to grab the banner and check for version
    # <= 2.0.7
    # I suppose that any version < 2 is vulnerable...
    r = recv(socket:soc, length:4096);
    if(ereg(string:r, pattern:".*EFTP version ([01]|2\.0\.[0-7])\..*"))
     vuln = 1;
   }
  }
  close(soc);
  if (vuln)
  {
   if (tested)
   {
    security_warning(port);
   }
   else
   {
    rep="The remote FTP server may be used to determine if a given
file exists on the remote host or not, by adding dot-dot-slashes
in front of them. 

For instance, it should be possible to determine the presence
of \autoexec.bat by using the command SIZE or MDTM on
../../../../autoexec.bat

An attacker may use this flaw to gain more knowledge about
this host, such as its file layout. This flaw is specially
useful when used with other vulnerabilities.

*** Nessus could not test the presence of autoexec.bat
*** and solely relied on the version number of your
*** server, so this may be a false positive.

Solution : update your FTP server and change it
Risk factor : Low";
    security_warning(port:port, report:rep);
   }
   exit(0);
  }
 }
}
