#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11011);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Port 445 open when 139 is not";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote port 445 is open while port 139 is not. 

Port 445 is used for 'Netbios-less' communication between
two Windows 2000 hosts. An attacker may use it the same way
as Nessus would do with port 139 - try to enumerate users, access
shares, and so on...

Solution : filter incoming traffic to this port
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for openness of port 445";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");

 family["english"] = "Windows";

 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
 script_require_ports(445);
 exit(0);
}

#
# The script code starts here
#

if(get_port_state(139))
{
  soc = open_sock_tcp(139);
  if(soc)exit(0);
}

if(get_port_state(445))
{
  soc = open_sock_tcp(445);
  if(soc)security_hole(445);
}
