#
# This script was written by Michel Arboi <arboi@algoriel.fr>
#
# GPL
#

if(description)
{
  script_id(10920);
  script_version ("$Revision: 1.3 $");
 
  script_name(english:"RemotelyAnywhere WWW detection");
 
  desc["english"] = "
The RemotelyAnywhere www server is running on this port.
According to NAVCIRT, http://www.technews.com/news/02/175245.html
attackers love this management tool.

If you installed it, ignore this warning. If not, your machine is compromised.
Risk factor : None / High";

  script_description(english:desc["english"]);
 
  summary["english"] = "Detect RemotelyAnywhere www server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
  family["english"] = "Backdoors";
  script_family(english:family["english"]);
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 2000,2001);
  exit(0);
}

port = get_kb_item("Services/www");
if (! port) port = 2000;

banner = get_kb_item(string("www/banner/", port));
if (! banner)
{
  soc = open_sock_tcp(port);
  if(soc)
  {
    req = http_head(item:"/", port:port);
    send(socket:soc, data:req);
    banner = recv(socket:soc, length:1000);
    close(soc);
  }
}

if (! banner) exit(0);

if (ereg(pattern:"Server: *RemotelyAnywhere", string:banner))
{
  security_note(port);
}

# TBD: check default account administrator / remotelyanywhere
