#
# This script was written by Michel Arboi <arboi@algoriel.fr>
#
# GPL
#

if(description)
{
  script_id(10921);
  script_version ("$Revision: 1.2 $");
 
  script_name(english:"RemotelyAnywhere SSH detection");
 
  desc["english"] = "
The RemotelyAnywhere SSH server is running on this port.
According to NAVCIRT, http://www.technews.com/news/02/175245.html
crackers love this management tool.

If you installed it, ignore this warning. If not, your machine is 
compromised.


Risk factor : None / High";

  script_description(english:desc["english"]);
 
  summary["english"] = "Detect RemotelyAnywhere SSH server";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
  family["english"] = "Backdoors";
  script_family(english:family["english"]);
  script_dependencie("find_service.nes");
  script_require_ports("Services/ssh", 22); 
  exit(0);
}

port = get_kb_item("Services/ssh");
if (! port) port = 22;

banner = get_kb_item(string("ssh/banner/", port));

if (! banner)
{
  soc = open_sock_tcp(port);
  if(soc)
  {
    banner = recv(socket:soc, length:1024);
    close(soc);
  }
}

if (! banner) exit(0);

if (ereg(pattern:"SSH-[0-9.-]+[ \t]+RemotelyAnywhere", string:banner))
{
  security_note(port);
}

# TBD: check default account administrator / remotelyanywhere
