#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10794);
 script_version ("$Revision: 1.11 $");
 name["english"] = "PC Anywhere TCP";
 name["francais"] = "PC Anywhere TCP";
 script_name(english:name["english"], francais:name["francais"]);

 
 desc["english"] = "PC Anywhere is running.

This service could be used by an attacker to partially take
control of the remote system if they obtain the
credentials necessary to log in (through a brute force
attack or by other means).

An attacker may use it to steal your password or prevent
your system from working properly.

Solution : disable this service if you do not use it.

Risk factor : Medium";

  desc["francais"] = "PC Anywhere est activ.

Ce service peut tre utilis par des pirates pour prendre le 
controle de la machine distante.

Un pirate peut l'utiliser pour voler vos mots de passes ou
vous empecher de travailler convenablement.

Solution : Dsactivez ce service si vous ne l'utilisez pas

Facteur de risque : Moyen";

  script_description(english:desc["english"], francais:desc["francais"]);


   summary["english"] = "Checks for the presence PC Anywhere";
   summary["francais"] = "Vrifie la prsence de PC Anywhere";
   script_summary(english:summary["english"], francais:summary["francais"]);


 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com",
                francais:"Ce script est Copyright (C) 2001 Alert4Web.com");

 family["english"] = "Backdoors";
 family["francais"] = "Backdoors";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/unknown", 5631, 65301);


exit(0);
}


function probe(port)
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  for (i=0; i < 10; i = i+1)
  {
    r = recv_line(socket:soc, length:1024, timeout:2);
    pca_ban = egrep(pattern:".*Please press.*",string:r);
    if(pca_ban)
    {
       set_kb_item(name:"Services/pcanywheredata", value:port);
       security_warning(port);
       i = 10;
    }
  }
  close(soc);
 }
}



port = get_kb_item("Services/unknown");
if(port)
{
 if(get_port_state(port))
  probe(port:port);
}
else
{
 if(get_port_state(5631))
  probe(port:5631);
 if(get_port_state(65301))
  probe(port:65301);
}
