#
# This script was written by Forrest Rae <forrest.rae@digitaldefense.net>
#
# See the Nessus Scripts License for details
#

##
#
# this script attempts to retrieve Novell 
# server info via ncp (524)
#
##

if(description)
{
 script_id(10988);
 script_version("$Revision: 1.2 $");
 name["english"] = "Netware NDS Object Enumeration";
 script_name(english:name["english"]);
 
 desc["english"] = "This host is a Novell Netware 
server, and has browse rights on the PUBLIC object.  
It is possible to enumerate all NDS objects, including 
users, with crafted queries.  An attacker can use 
this to gain information about this host.

Solution: The NDS object PUBLIC should not have Browse 
rights; the tree should be restricted to 
authenticated users only.  Removing Browse rights 
from the object will fix this issue.  If this is 
an external system it is recommended that access 
to port 524 be blocked from the Internet.

Risk factor : Low";
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Netware NDS Object Enumeration";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Digital Defense, Inc");
 family["english"] = "Misc.";
 script_family(english:family["english"])
 script_require_ports(524);
 exit(0);
}

#
# The script code starts here
#

ddidata = string("Data: Netware NDS Object Enumeration");
port = 524;

conn_create = raw_string (	0x44, 0x6d, 0x64, 0x54,	# NCP over IP signature: Demand Transport
				0x00, 0x00, 0x00, 0x17,	# NCP over IP Length: 0x00000017 (23 bytes)
				0x00, 0x00, 0x00, 0x01,	# NCP over IP version: 1
				0x00, 0x00, 0x00, 0x00,	# NCP over IP Reply Buffer Size: 0
				0x11, 0x11,		# Type: Create a service connection
				0x00,			# Initial sequence number 0x00
				0xff,			# Connection Number low, 0xff (255) wildcard
				0x01,			# Task Number: 1
				0xff,			# Connection Number high, 0xff (255) wildcard
				0x04);			# Group: Connection
				  

# Get Port State
if(get_port_state(port))
{
	# Open stream socket
	soc = open_sock_tcp(port);
	
	if(soc)
	{
		# Build the NCP connection
		send(socket:soc, data:conn_create);
		r = recv(socket:soc, length:4096);
		
		# Check for successful connection
		# NCP over IP signature: 0x744e6350 = "tNcP"
		if("tNcP" >< r)
		{
			# Grab the connection number from the Connection Request Reply
			# 12th and 14th byte of the raw_string r
			conn_number_low = 1;
			conn_number_high = 1;
			
			conn_number_low = r[11];
			conn_number_high = r[13];
			
			#####################################################
			# Get Server Name
			#####################################################
			
			# Build our info req string
			# 20th byte is conn_number_low
			# 22nd byte is conn_numger_high
			server_info_req = raw_string (	0x44, 0x6d, 0x64, 0x54,	# NCP over IP signature: Demand Transport
							0x00, 0x00, 0x00, 0x1a,	# NCP over IP Length: 26 bytes
			 				0x00, 0x00, 0x00, 0x01,	# NCP over IP version: 1
							0x00, 0x00, 0x00, 0x80,	# NCP over IP Reply Buffer Size: 128
 							0x22, 0x22,		# Type: Service Request
							0x01,			# Sequence number
							ord(conn_number_low),	# Connection Number low
							0x01,			# Task Number: 1
							ord(conn_number_high),	# Connection Number high
							0x17,			# Function Code: Get File Server Information
							0x00, 0x01,		# Packet Length: 1
							0x11);			# Subfunction
			
			
			# send request
			send(socket:soc, data:server_info_req);
			r = recv(socket:soc, length:4096);
			
			# Check for successful request
			# NCP over IP signature: 0x744e6350 = "tNcP"
			if("tNcP" >< r)
			{
				# Create empty string, not sure if this is required.
				server_name = string("");

				# Build server name.
				for( i = 16; i < 63; i = i +1)
				{
					if(ord(r[i]) != 0)
					{
						server_name = string(server_name, r[i]);
					}
				}
				
				report = string("Server Name: ", server_name, "\n");
			}
			
			#####################################################
			# Get NDS Tree Name with a NDS_Ping
			#####################################################
			
			# Build our NDS_Ping string
			# 20th byte is conn_number_low
			# 22nd byte is conn_numger_high
			nds_ping_req = raw_string (	0x44, 0x6d, 0x64, 0x54,	# NCP over IP signature: Demand Transport
							0x00, 0x00, 0x00, 0x1b,	# NCP over IP Length: 27 bytes
							0x00, 0x00, 0x00, 0x01,	# NCP over IP version: 1
							0x00, 0x00, 0x00, 0x28,	# NCP over IP Reply Buffer Size: 128
							0x22, 0x22,		# Type: Service Request
							0x02,			# Sequence number
							ord(conn_number_low),	# Connection Number low
							0x01,			# Task Number: 1
							ord(conn_number_high),	# Connection Number high
							0x68,			# Function Code: Ping for NDS NCP
							0x01, 			# Subfunction
							0x00, 0x00, 0x00);	# Reserved Bytes

			# send request
			send(socket:soc, data:nds_ping_req);
			r = recv(socket:soc, length:4096);

			# Check for successful request
			# NCP over IP signature: 0x744e6350 = "tNcP"
			if("tNcP" >< r)
			{
				# Create empty string, not sure if this is required.
				nds_tree_name = string("");

				# Build NDS Tree Name.
				for( i = 24; i < 45; i = i +1)
				{
					if((r[i] >< "_") && (r[i+1] >< "_"))
					{
						# do nothing :)
					}
					else
					{
						nds_tree_name = string(nds_tree_name, r[i]);
					}
				}
				
                		report = string(report, "NDS Tree Name: ", nds_tree_name);
                		security_warning(port:port, data:report);
			}
			
		}
		close(soc);
	}
}

