/*
 * Check SSL ciphers & certificates
 *
 * This plugin connects to a SSL server, checks its certificate and the
 * available ciphers
 *
 * This plugin was written by Michel Arboi <arboi@bigfoot.com>
 */
 
#include <includes.h>


#define EN_NAME "SSL ciphers"
#define FR_NAME "Chiffres SSL"

/*
#define EN_DESC "\
This plugin connects to a SSL server, and\n\
checks its certificate and the available ciphers.\n\
Weak (export version) ciphers are reported, as well as \n\
self signed certificates or certificates signed by unknown\n\
CAs."
*/
#define EN_DESC "\
This plugin connects to a SSL server, and\n\
checks its certificate and the available ciphers.\n\
Weak (export version) ciphers are reported."

#define COPYRIGHT "(C) 2002 Michel Arboi"
#define SUMMARY "checks the server certificate and available ciphers"

PlugExport int plugin_init(desc)
     struct arglist * desc;
{
#ifndef HAVE_SSL
  return -1;
#else
  plug_set_id(desc, 10863);
  plug_set_version(desc, "$Revision: 1.4 $");
 
  plug_set_name(desc, FR_NAME, "francais");
  plug_set_name(desc, EN_NAME, NULL);
  
  plug_set_description(desc, EN_DESC, NULL);
  plug_set_summary(desc, SUMMARY, NULL);
  plug_set_copyright(desc, COPYRIGHT, NULL);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "General", NULL);
  plug_set_dep(desc, "find_service.nes");
  return 0;
#endif
}


PlugExport 
int plugin_run(env)
     struct arglist * env;
{
#ifndef HAVE_SSL
  return -1;
#else
  char		*p, *trp_name, *trp0_name;
  int		port, trp, trp0, cnx = -1, i, bits;
  char		*name, buf[128], rep[512];
  SSL_CIPHER		*c = NULL;
  SSL			*ssl = NULL;
  STACK_OF(SSL_CIPHER)	*ciphers = NULL;
  int			weak = 0, medium = 0, strong = 0, null =0, nCiphers = 0;
  int			cert_printed = 0;
  char			*msg;
  X509			*cert;
  BIO			*b;
  BUF_MEM		*bptr;
  int			rejected[3];
    
  
  p  = plug_get_key(env, "Transport/SSL");
  if (p == NULL)
    return 0;
  port = atoi(p);

  trp0 = plug_get_port_transport(env, port);
  trp0_name = get_encaps_name(trp0);

  for (trp = NESSUS_ENCAPS_SSLv2; trp <=  NESSUS_ENCAPS_TLSv1; trp ++)
    {
      if (cnx >= 0)
	{
	  close_stream_connection(cnx);
	  cnx = -1;
	}

      if ((cnx = open_stream_connection(env, port, trp, -2)) < 0)
	{
	  rejected[trp - NESSUS_ENCAPS_SSLv2]  = 1;
	  continue;
	}
      rejected[trp - NESSUS_ENCAPS_SSLv2]  = 0;

      if ((ssl = stream_get_ssl(cnx)) == NULL)
	continue;

      trp_name = get_encaps_name(trp);

      if (! cert_printed)
	{
	  cert = SSL_get_peer_certificate(ssl);
	  if(cert != NULL)
	    {
	      b = BIO_new(BIO_s_mem());
	      if(X509_print(b, cert) > 0)
		{
		  BIO_get_mem_ptr(b, &bptr);
		  msg = emalloc(bptr->length + 1 + 80);
		  sprintf(msg, "Here is the %s server certificate:\n",
			  trp_name);
		  for (p = msg; *p != '\0'; p ++) /*NOP*/ ;
		  strncpy(p, bptr->data, bptr->length);
		  post_note(env, port, msg);
		  efree(&msg);
		}
	      BIO_free(b);
	      cert_printed ++;
	    }
	}

      if ((ciphers = SSL_get_ciphers(ssl)) == NULL)
	continue;

      nCiphers = sk_SSL_CIPHER_num(ciphers);
      msg = emalloc(nCiphers * sizeof(buf) + 256);
      sprintf(msg, "Here is the list of available %s ciphers:\n", trp_name);
      p = msg;
      for (i = 0; i < nCiphers; i++)
	{
	  c = sk_SSL_CIPHER_value(ciphers, i);
	  name = SSL_CIPHER_get_name(c);
	  SSL_CIPHER_get_bits(c, &bits);
	  /* 
	   * OpenSSL returns the number of secret bits of the algorithm, but
	   * does not say how many of them are fixed or known.
	   * So we have to check if the algorithm is "export grade"
	   */
	  if (bits == 0)
	    null ++;
	  else
	    if (strncmp(name, "EXP", 3) == 0)
	      weak ++;
	    else if (bits < 56)	/* arbitrary limit 1. You may disagree */
	      weak ++;
	    else if (bits < 90)	/* arbitrary limit 2. Same remark */
	      medium ++;
	    else
	      strong ++;
	  (void) SSL_CIPHER_description(c, buf, sizeof(buf));
	  while (*p != '\0') p++;
	  strcpy(p, buf);
	}

      post_note(env, port, msg);
      efree(&msg);
      
      if (null >= nCiphers)
	{
	  sprintf(rep, "\
The %s server only accepts \"null\" ciphers, which do not protect the\
confidentiality of your data.\n\
\n\
Solution: re-configure or upgrade your server software.",
		  trp_name);
	  post_hole(env, port, rep);
	}
      else
	{
	  if (null > 0)
	    {
	      sprintf(rep, "\
The %s server accepts %d \"null\" ciphers which do *not*\n\
protect the confidentiality of your data\n\
You should disable them, as they may be chosen by a badly\n\
configured client software.\
\n\
Solution: re-configure or upgrade your server software.",
		      trp_name, null);
	      post_hole(env, port, rep);
	    }

	  if (strong == 0)
	    {
	      sprintf(rep, "\
The %s server does not accept strong \"US grade\" ciphers\n\
with 112 or 128 bit long secret keys\n\
Nessus only counted %d weak \"export class\" and %d medium strength ciphers.\n\
Those ciphers only offer a limited protection against a brute force attack.\n\
\n\
Solution: update your server certificate and/or\n\
upgrade your SSL library or server software.",
		      trp_name, weak, medium);
	      post_hole(env, port, rep);
	    }
	  else if (weak > 0 || medium > 0)
	    {
	      sprintf(rep, "\
The %s server offers %d strong ciphers, but also\n\
%d medium strength and %d weak \"export class\" ciphers.\n\
The weak/medium ciphers may be chosen by an export-grade\n\
or badly configured client software. They only offer a \n\
limited protection against a brute force attack\n\
\n\
Solution: disable those ciphers and upgrade your client\n\
software if necessary",
		      trp_name, strong, medium, weak);
	      post_info(env, port, rep);
	    }
	}
    }

  
  if (! rejected[trp0 - NESSUS_ENCAPS_SSLv2])
    {
      
      for (trp = NESSUS_ENCAPS_SSLv2; trp <= NESSUS_ENCAPS_TLSv1; trp ++)
	if (rejected[trp - NESSUS_ENCAPS_SSLv2])
	  {
	    sprintf(rep, "This %s server does not accept %s connections",
		    trp0_name, get_encaps_name(trp));
	    post_note(env, port, rep);
	  }
    }

  for (trp = NESSUS_ENCAPS_SSLv2; trp <= NESSUS_ENCAPS_TLSv1; trp ++)
    if (trp != trp0 && ! rejected[trp - NESSUS_ENCAPS_SSLv2])
      {
	sprintf(rep, "This %s server also accepts %s connections",
		trp0_name, get_encaps_name(trp));
	post_note(env, port, rep);
      }
    
  if (cnx >= 0)
    close_stream_connection(cnx);
  return 0;
#endif
}


