/*
 * $Id: network.c,v 1.8 2002/03/05 11:55:11 renaud Exp $
 *
 * Network related functions
 *
 */
 
#include <includes.h>


/* negociate a telnet session */ 		  
int 
init_telnet_session(soc)
 int soc;
{
 unsigned char iac = 255, code, option;
 struct timeval tv = {5,0};
 while(iac == 255)
 {
  fd_set read;
  char c[3];
  int n;
  stream_zero(&read);
  n = stream_set(soc, &read);
  select(n+1, &read, NULL, NULL, &tv);
  if(!stream_set(soc, &read))return(-1);
  if((read_stream_connection(soc, c, 3))!=3)return(-1);
  iac = c[0];
  if(iac != 255)break;
  code = c[1];
  option = c[2];
  if((code == 251)||(code == 252))code = 254; /* WILL, WONT -> DONT */
  else
  if((code == 253)||(code == 254))code = 252; /* DO, DONT -> WONT */
  c[0] = iac;
  c[1] = code;
  c[2] = option;
  write_stream_connection(soc, c, 3);
  tv.tv_sec = 0;
  tv.tv_usec = 300000;
 }
  return(iac);
}


/* 
 * initiate <num> connections on port <port>
 *
 * If <telnet> is set to 1, then the negociation
 * is done.
 *
 */
int *
init_telnet_connections(data, port, num, telnet)
 struct arglist * data;
 int port;
 int num;
 int telnet;
{
 int * ret;
 int i;
 int cnt = 0;
 ret = emalloc(sizeof(int)*(num+1));
 for(i=0;i<num;i++)
 {
  int one = 1;
  ret[i] = open_stream_auto_encaps(data, port, 5);
  setsockopt(nessus_get_socket_from_connection(ret[i]), SOL_SOCKET, SO_RCVLOWAT, &one, sizeof(one));
  if(telnet)
  {
  if((init_telnet_session(ret[i]))==-1){
  	close_stream_connection(ret[i]);
	ret[i]=-1;
	break;
	}
  else cnt++;
  }
 }
 return(ret);
}

/*
 * Read the data waiting on every socket
 */
char ** 
read_all(sockets, limit)
 int * sockets;
 int limit;
{
 fd_set fd;
 struct timeval tv;
 int i;
 int max = 0;
 char ** ret;
 int num_wait = 0;
 
 tv.tv_sec = 5;
 tv.tv_usec = 0;
 stream_zero(&fd);
 for(i=0;i<limit;i++)
 {
  if(sockets[i]!=-1){
  		int m  = stream_set(sockets[i], &fd);
		if(m > max)max = m;
  }
 }
 ret = emalloc((limit+1)*sizeof(char*));
 bzero(ret, (limit+1)*sizeof(char*));
 while(select(max+1, &fd, NULL, NULL, &tv)>0)
 {
  num_wait++;
  for(i=0;i<limit;i++)
  {
   if((sockets[i]!=-1) && (stream_set(sockets[i], &fd)))
   {
    int n;
    int k;
    int orig;
    if(!ret[i]){
    	ret[i] = emalloc(2048);
	}
    orig = strlen(ret[i]);
    n = read_stream_connection(sockets[i], ret[i]+orig, 2048-orig);
    if(n<=0)
    {
     if(ret[i]){
	efree(&(ret[i]));
	ret[i] = NULL;
	}
     close_stream_connection(sockets[i]);
     sockets[i] = -1;
    }
    else for(k=orig;k<n+orig;k++)
    {
 	if(!isprint(ret[i][k])) /* weird chars -> '.' */
	  ret[i][k]='.';
    }
   }
  }
 if(num_wait > 5)break;
 tv.tv_sec = 0;
 tv.tv_usec = 30000;
 stream_zero(&fd);
 max = 0;
 for(i=0;i<limit;i++)
  {
  int m = 0;
  if(sockets[i]!=-1)m = stream_set(sockets[i], &fd);
  if(m > max)max = m;
  }
 }
 return(ret);
}




