/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define EXPORTING
#include <includes.h>
#include "system.h"
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#if 0 /* Enable this if you want to check the integrity of the data
	 blocks when freeing.  You probably might coose to set additional
	 flags for debugging in libleks/memalloc.c */
#include "peks/peks.h"
#define malloc pmalloc
#define free   xfree
#endif





#ifdef HUNT_MEM_LEAKS
/*
 * Trust me, you don't want to enable this option.
 * It's only useful to a few nerds. If ever you
 * enable this option :
 *	- ask me the "analyze.c" program which analyzes
 *	  the report
 *	- only have a few plugins installed.
 *
 *
 *
 * The reason why I don't use dmalloc is mostly that
 * it would say that emalloc() leaks memory. Duh. Thanks.
 *
 */
#undef malloc
#undef free
#undef strdup
#undef realloc

#include <stdio.h>
static FILE * f = NULL;

void * __hml_malloc(file, line, size)
 char * file;
 int line;
 size_t size;
{
 void * ptr;
 if(!f)
 {
  char name[255];
  int fd;
  sprintf(name, "/tmp/nessus-memleaks.%d", getpid());
  fd = open(name, O_RDWR|O_CREAT|O_SYNC);
  f = fdopen(fd, "w");
 }
 
 ptr = malloc(size + 1);
 bzero(ptr, size + 1);
 fprintf(f, "0x%x %d allocated by %s:%d (%d bytes)\n", ptr,getpid(), file, line, size+1);
 fflush(f);
 return ptr;
} 

void *
__hml_realloc(file, line, ptr, size)
	char* file;
	int line;
	void * ptr;
	size_t size;
{
	void * ret = __hml_malloc(file, line, size);
	memcpy(ret, ptr, size);
	__hml_free(file, line, &ptr);
	return ret;
}

void __hml_free(file, line, ptr)
 char * file;
 int line;
 void * ptr;
{
  char ** p = ptr;
    if(p && *p){
        if(!f)
	{
	char name[255];
  	int fd;
 	sprintf(name, "/tmp/nessus-memleaks.%d", getpid());
  	fd = open(name, O_RDWR|O_CREAT|O_SYNC);
  	f = fdopen(fd, "w");
	}
    	fprintf(f, "0x%x %d freed by %s:%d\n", *p, getpid(), file, line);
    	free(*p);
    	*p=NULL;
	}
}

char*
__hml_strdup(file, line, str)
 char * file;
 int line;
 char * str;
{
    char * buf;
    if (!str) return NULL;
    buf = malloc(strlen(str)+1);
    strncpy(buf, str, strlen(str)+1);
    if(!f)
     {
     char name[255];
  int fd;
  sprintf(name, "/tmp/nessus-memleaks.%d", getpid());
  fd = open(name, O_RDWR|O_CREAT|O_SYNC);
  f = fdopen(fd, "w");
     }
    fprintf(f, "0x%x %d allocated by %s:%d (%d bytes)\n", buf,getpid(), file, line, strlen(str) + 1);
    return buf;
}



#else


ExtFunc
void * emalloc(size)
 size_t size;
{
    void * ptr;
   
    /*
     * Just for our personal safety, we increase the 
     * size by one
     */
    size++;
   
   
    /*
     * If no memory can be allocated, then wait a little.
     * It's very likely that another nessusd child will free
     * the size of memory we need. So we make 10 attempts,
     * and if nothing happens, then we exit
     */
    ptr = malloc(size);
    if(!ptr){
    	int i;
	for(i=0;(i<10)&&!ptr;i++)
	{
	 usleep(1000);
	 ptr = malloc(size);
	}
	
	if(!ptr)
	{
	 fprintf(stderr, "[%d] Could not allocate a pointer of size %d !\n", getpid(), size);
	 exit(1);
	}
      }
    bzero(ptr, size);
    return(ptr);
}

ExtFunc char * 
estrdup(str)
 const char * str; 
{
    char * buf;
    if (!str) return NULL;
    buf = emalloc(strlen(str)+1);
    strncpy(buf, str, strlen(str)+1);
    return buf;
}


ExtFunc void 
efree(ptr)
 void * ptr;
{
    char ** p = ptr;
    if(p && *p){
    	free(*p);
    	*p=NULL;
	}
}

ExtFunc void *
erealloc(ptr, size)
 void * ptr;
 size_t size;
{
  void * ret = realloc(ptr, size);
  if(!ret)
  {
    fprintf(stderr, "Could not realloc() a pointer of size %d !\n",
		size);
    exit (1);
  }
 return ret;
}


#endif

ExtFunc size_t 
estrlen(s,n)
 const char * s; 
 size_t n;
{
    size_t i;
    for(i = 0; (*(s+i) != '\0' && i < n); i++);
    return i;
}



#ifndef HAVE_INET_ATON
/*
 * Coming straight from Fyodor's Nmap
 */
int
inet_aton(cp, addr)
	register const char *cp;
	struct in_addr *addr;
{
	register unsigned int val;	/* changed from u_long --david */
	register int base, n;
	register char c;
	u_int parts[4];
	register u_int *pp = parts;

	c = *cp;
	for (;;) {
		/*
		 * Collect number up to ``.''.
		 * Values are specified as for C:
		 * 0x=hex, 0=octal, isdigit=decimal.
		 */
		if (!isdigit((int)c))
			return (0);
		val = 0; base = 10;
		if (c == '0') {
			c = *++cp;
			if (c == 'x' || c == 'X')
				base = 16, c = *++cp;
			else
				base = 8;
		}
		for (;;) {
			if (isascii((int)c) && isdigit((int)c)) {
				val = (val * base) + (c - '0');
				c = *++cp;
			} else if (base == 16 && isascii((int)c) && isxdigit((int)c)) {
				val = (val << 4) |
					(c + 10 - (islower((int)c) ? 'a' : 'A'));
				c = *++cp;
			} else
				break;
		}
		if (c == '.') {
			/*
			 * Internet format:
			 *	a.b.c.d
			 *	a.b.c	(with c treated as 16 bits)
			 *	a.b	(with b treated as 24 bits)
			 */
			if (pp >= parts + 3)
				return (0);
			*pp++ = val;
			c = *++cp;
		} else
			break;
	}
	/*
	 * Check for trailing characters.
	 */
	if (c != '\0' && (!isascii((int)c) || !isspace((int)c)))
		return (0);
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	n = pp - parts + 1;
	switch (n) {

	case 0:
		return (0);		/* initial nondigit */

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return (0);
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if (addr)
		addr->s_addr = htonl(val);
	return (1);
}
#endif
