/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */


 
#include <includes.h>
#ifdef NESSUSNT
#include "wstuff.h"
#endif

#include "log.h"
#include "ntp.h"
#include "threads.h"
#include "auth.h"
#include "comm.h"
#include "plugs_deps.h"
#include "utils.h"
#include "ntp_11.h"
#include "rtree.h"
#include "preferences.h"
#include "detached.h"
#include "save_tests.h"



extern int g_max_hosts;
extern int g_max_checks;
static int check_client_input(struct arglist *, int, struct attack_atom**);



/*
 * version check (for libraries)
 *
 * Returns 0  if versions are equal
 * Returns 1 if the fist version is newer than the second 
 * Return -1 if the first version is older than the second
 *
 */
int 
version_check(a,b)
 char * a, *b;
{
 int int_a, int_b;
 
 if(!a || !b) return -2; 
 
 int_a = atoi(a);
 int_b = atoi(b);
 
 if(int_a < int_b) return -1;
 if(int_a > int_b) return 1;
 else {
  char * dot_a = strchr(a, '.'), * dot_b = strchr(b, '.');
  if(dot_a && dot_b)
   return version_check(&(dot_a[1]), &(dot_b[1]));
  else 
   return -2;
 }
}


/*
 * Returns <1> if the two arglists have a value in common
 */
int
common(l1, l2)
 struct arglist * l1, *l2;
{
 if(!l1 || !l2)
  {
#ifdef DEBUG
   printf("common(): l1 =%d, l2 = %d\n", l1, l2);
#endif   
  return 0;
 }
 while(l1->next)
 {
  while(l2->next)
  {
   if(l1->type == l2->type)
   {
    if(l1->type == ARG_INT)
    {
#ifdef DEBUG
     printf("common(): (int)%d == %d ?\n", l1->value, l2->value);
#endif     
     if(l1->value == l2->value)
      return 1;
    }
    else if(l1->type == ARG_STRING)
    {
#ifdef DEBUG
     printf("common(): (str)%s == %s ?\n", l1->value, l2->value);
#endif     
     if(!strcmp(l1->value, l2->value))
      return 1;
    }
   }
   l2 = l2->next;
  }
  l1 = l1->next;
 }
 return 0;
}
/*
 * Converts a user comma delimited input (1,2,3) into an
 * arglist
 */
struct arglist *
list2arglist(list)
 char * list;
{
 struct arglist * ret = emalloc(sizeof(struct arglist));
 char * t = strchr(list, ',');
 int port;
 if(!list)
  {
   efree(&ret);
   return ret;
  }
  
  
 while((t = strchr(list, ',')) != NULL)
 {
  t[0] = 0;
  while(list[0]==' ')list++;
  if(strlen(list))
  {
  port = atoi(list);
  if(!port)
   arg_add_value(ret, "port", ARG_STRING, strlen(list), estrdup(list));
  else
   arg_add_value(ret, "port", ARG_INT, sizeof(int), (void*)port);
  }
  list = t+1;
 }
 
 while(list[0]==' ')list++;
 if(strlen(list))
  {
   port = atoi(list);
  if(!port)
   arg_add_value(ret, "port", ARG_STRING, strlen(list), estrdup(list));
  else
   arg_add_value(ret, "port", ARG_INT, sizeof(int), (void*)port);
  }
  return ret;
}

 
/*
 * Sort the plugins by type (SCANNER, GATHER_INFO, ATTACK, DENIAL, PASSIVE)
 *
 * This "algorithm" is downright ugly, but it works, and since I'm
 * not seeking the best performances right now, well, it fits my need
 *
 */
struct arglist * 
sort_plugins_by_type(lplugs)
 struct arglist * lplugs;
{
 struct arglist * plugins = lplugs;
 struct arglist * ret;
 struct arglist * tplugs = emalloc(sizeof(struct arglist));
 int i;
 ret = tplugs;

 for (i = ACT_FIRST; i <= ACT_LAST; i ++)
    {
      while(lplugs && lplugs->next)
	{
	  struct arglist * args;
	  
	  args = arg_get_value(lplugs->value, "plugin_args");
	  if(args && ((int)arg_get_value(args, "CATEGORY")==i))
	    {
	      arg_add_value(ret, lplugs->name, lplugs->type, lplugs->length, lplugs->value);
	    }
	  lplugs = lplugs->next;
	}
      lplugs = plugins;
    }
   return(ret);
}

/* 
 * Get the max number of hosts to test at the same time
 */
int 
get_max_hosts_number(preferences)
 struct arglist * preferences;
{
  int max_hosts;
  if(arg_get_value(preferences, "max_hosts"))
    {
      max_hosts = atoi(arg_get_value(preferences, "max_hosts"));
      if(max_hosts<=0)
	{
	  log_write("Error ! max_hosts = %d -- check %s\n", 
		    max_hosts, (char *)arg_get_value(preferences, "config_file"));
	  max_hosts = g_max_hosts;
	}
    else if(max_hosts > g_max_hosts)
     {
     	log_write("Client tried to raise the maximum hosts number - %d. Using %d. Change 'max_hosts' in nessusd.conf if \
you believe this is incorrect\n",
			max_hosts, g_max_hosts);
	max_hosts = g_max_hosts;
     }
    }
  else max_hosts = g_max_hosts;
  return(max_hosts);
}

/* 
 * Get the max number of plugins to launch against the remote
 * host at the same time
 */
int
get_max_checks_number(preferences)
 struct arglist * preferences;
{
 int max_checks;
  if(arg_get_value(preferences, "max_checks"))
    {
      max_checks = atoi(arg_get_value(preferences, "max_checks"));
      if(max_checks<=0)
	{
	  log_write("Error ! max_hosts = %d -- check %s\n", 
		    max_checks, (char *)arg_get_value(preferences, "config_file"));
	  max_checks = g_max_checks;
	}
    else if(max_checks > g_max_checks)
     {
     	log_write("Client tried to raise the maximum checks number - %d. Using %d. Change 'max_checks' in nessusd.conf if \
you believe this is incorrect\n",
			max_checks, g_max_checks);
	max_checks = g_max_checks;
     }
    }
  else max_checks = g_max_checks;
  return(max_checks);
}


/*
 * Returns the number of plugins that will be launched
 */
int 
get_active_plugins_number(plugins)
 struct rtree *  plugins;
{
  int num = 0;
  struct rtree * nxt;
  int i,l;
  struct arglist * plugin;
  
  plugins = rtree_root(plugins);
  plugin = rtree_node_data(plugins);
  if(plugin)
    if(plug_get_launch(plugin->value))num++;
  
  for(;;)
  {
  nxt = rtree_node_get_nth_node(plugins, 0);
  l = rtree_node_num_elems(plugins);
  for(i=0;i<l;i++)
  {
   struct rtree * node = rtree_node_get_nth_node(plugins, i);
   plugin = (struct arglist*)rtree_node_data(node);
   if(plugin)
   {
    int category = (int)arg_get_value(arg_get_value(plugin->value, "plugin_args"), 
	 			     "CATEGORY");
    if(plug_get_launch(plugin->value) || (category == ACT_SETTINGS))num++;
   }
  }
  if(nxt && nxt != RTREE_INVAL_NODE)plugins = nxt;
  else break;
  }
  return num;
}


void 
send_plugin_order(globals, plugins)
 struct arglist * globals;
 struct rtree * plugins;
{
 int num; 
 char * str;
 int i;
 
 
  num = get_active_plugins_number(plugins);
  if(!num)num = 1;
  str = malloc(num*10+1);
  str[0]='\0';
  for(i = ACT_FIRST; i <= ACT_LAST ; i++)
  {
    char sp[10];
    struct arglist * plugin;
    
    
    plugins = rtree_root(plugins);
    plugin =  rtree_node_data(plugins);
    if(plugin && plug_get_launch(plugin->value))
     {
      struct arglist *v = arg_get_value(plugin->value, "plugin_args");
      int category = (int)arg_get_value(v, "CATEGORY");
      if(i == category)
      {
      sprintf(sp, "%d", (int)arg_get_value(v, "ID"));
      strcat(str, sp);
      strcat(str, ";");
      }
     }
    for(;;)
    {
     struct rtree * next_layer = rtree_node_get_nth_node(plugins, 0);
     int j, l = rtree_node_num_elems(plugins);
     for(j = 0;j<l;j++)
     {
      struct rtree * node;
      int category = -1;
      
      
      node = rtree_node_get_nth_node(plugins, j);
      plugin = node ? rtree_node_data(node) : NULL;
      if(plugin)
      {
       category = (int)arg_get_value(arg_get_value(plugin->value, "plugin_args"), 
	 			     "CATEGORY");
				     
      }
      if(plugin &&
         (plug_get_launch(plugin->value) || category == ACT_SETTINGS))
	 {
	  struct arglist *v = arg_get_value(plugin->value, "plugin_args");
	  int category = (int)arg_get_value(v, "CATEGORY");
	  if(i == category)
	  {
          sprintf(sp, "%d", (int)arg_get_value(v, "ID"));
          strcat(str, sp);
          strcat(str, ";");
	  }
	 }
      }
      if(next_layer && next_layer != RTREE_INVAL_NODE)plugins = next_layer;
      else break;
     }
    }
  auth_printf(globals, "SERVER <|> PLUGINS_ORDER <|> %s <|> SERVER\n",
  		str);	
  free(str);
 
}


void 
plugins_set_ntp_caps(plugins, caps)
 struct arglist * plugins;
 ntp_caps* caps;
{
 if(!caps || !plugins)return;
 while(plugins->next)
 {
  struct arglist * v;
  if(plugins->value)
   v = arg_get_value(plugins->value, "plugin_args");
  else 
   v = NULL;
  
  if(v)arg_add_value(v, "NTP_CAPS", ARG_STRUCT, sizeof(*caps), caps);
  plugins = plugins->next;
 }
}



/*-----------------------------------------------------------------

   Process management : attack_atoms and check_threads_input()
	 
 ------------------------------------------------------------------*/	 
struct attack_atom ** 
attack_atom_new()
{
 struct attack_atom ** ret = emalloc(sizeof(struct attack_atom*));
 return ret;
}

void
attack_atom_free(atoms)
 struct attack_atom ** atoms;
{
 struct attack_atom * a;
 if(!atoms)
  return;
 
 
 a = *atoms;
 while(a)
 { 
  struct attack_atom * b;
  if(a->name)efree(&a->name);
  b = a->next;
  if(close(a->soc) < 0)
   perror("close ");
  if(close(a->psoc) < 0)
   perror("close ");
  efree(&a);
  a = b;
 }
 efree(&atoms);
}


void
attack_atom_free_others(atoms, name)
 struct attack_atom ** atoms;
 char * name;
{
 struct attack_atom *a;
 
 if(!atoms)
  return;
  
 a = *atoms;
 while(a)
 {
  struct attack_atom *b;
  b = a->next;
  if(!strcmp(a->name, name))
  {
   *atoms = a;
   a->next = NULL;
  }
  else
  {
   efree(&a->name);
   if(close(a->soc) < 0)
    perror("close ");
   if(close(a->psoc) < 0)
    perror("close ");
  }
  a = b;
 }
}

void
attack_atom_insert(atoms, name, soc, psoc)
 struct attack_atom** atoms;
 char * name;
 int soc, psoc;
{
 struct attack_atom * atom =  emalloc(sizeof(struct attack_atom));
 
 atom->name = estrdup(name);
 atom->soc = soc;
 atom->psoc = psoc;
 
 if(!atoms) 
  return;
 
 if(!(*atoms))
   *atoms = atom;
 else
 {
  struct attack_atom * a = *atoms;
  while(a->next)
   a = a->next;
  a->next = atom;
 } 
}

#ifdef DEBUG
void attack_atom_dump(atoms)
 struct attack_atom ** atoms;
{
 struct attack_atom * a = *atoms;
 while(a){
 	printf("%s -> ", a->name);
	a = a->next;
	}
 printf("\n");
}
#endif
void
attack_atom_remove(atoms, name)
 struct attack_atom ** atoms;
 char * name;
{
 struct attack_atom * a;
 
 if(!atoms)
  return;
  
 a = *atoms;
 
 if(!a || !name)
  {
  log_write("*** %s:%d trying to remove '%s' from 0x%x\n", 
  		__FILE__, __LINE__, name, (int)a);
  return;
  }
  
 if(a->name && !strcmp(a->name, name))
 {
  *atoms = a->next;
  if(close(a->soc) < 0)
   perror("close ");
  if(close(a->psoc) < 0)
   perror("close ");
   
  efree(&(a->name));
  efree(&a);
 }
 else
 {
  while(a->next)
  {
  if(a->next->name && !strcmp(a->next->name, name))
  {
   struct attack_atom * b = a->next;
   a->next = b->next; /* a->next = a->next->next */
   if(close(b->soc) < 0)
    perror("close "); 
   if(close(b->psoc) < 0)
    perror("close ");
   efree(&(b->name));
   efree(&b);
   return;
   }
   a = a->next;
  }
 }
}

int 
check_threads_input(atoms, sock, globals)
 struct attack_atom ** atoms;
 int sock;
 struct arglist * globals;
{
 fd_set rd, wr;
 struct timeval tv;
 char buffer[4096];
 int ret = 0;
 int max = -1;
 struct attack_atom * atom;
 struct arglist * preferences = arg_get_value(globals, "preferences");
 int	soc2 = sock;
 
 if(!atoms)
  atom = NULL;
 else
   atom = *atoms;
 
 if(sock > 0)
  sock = nessus_get_socket_from_connection(sock);
 

 
 FD_ZERO(&rd);
 FD_ZERO(&wr);
 while(atom)
 {
  if((int)atom->soc > max)max = (int)atom->soc;
  FD_SET((int)atom->soc, &rd);
  atom = atom->next;
 }

 if(sock > 0)
 {
  FD_SET(sock, &rd);
  FD_SET(sock, &wr);
  if(sock > max)max = sock;
 }
 
 bzero(&tv, sizeof(tv));
 tv.tv_sec = 5;
 
 
 if(select(max+1, &rd, &wr, NULL, &tv)>0)
 { 
   /*
    * Make sure that the client is still here
    */
   if((soc2 > 0) && (sock > 0) && !FD_ISSET(sock, &wr))
   {
    /* Client has shut the communication down */
    char d = 0;
    int r = nsend(soc2, &d, 0, 0);
    if(r < 0)
    {
     if((errno == EPIPE)||
        (errno == EBADF)||
        (errno == ENOTSOCK))
	{
	 if(!is_client_present(soc2)) return -1;
	}
     }
   }

   /*
    * If the client attempts to say something, read its input
    */
   if((soc2 > 0) && (sock > 0) && FD_ISSET(sock, &rd))
   {
    int e;
    if((e = check_client_input(globals, soc2, atoms))<0)
    {
     if(e == -1)
        {
	     if(!is_client_present(soc2)) return e;
     	}
      else return e;
     }
   }
   
  if(atoms)
   atom = *atoms;  
  else
   atom = NULL;
   
  while(atom)
  {
    struct attack_atom * next = atom->next;
    char dummy = 0;
      
     if(FD_ISSET(atom->soc, &rd))
     {
      int len;
      int n;
      fd_set wr;
      struct timeval tv;
      bzero(buffer, sizeof(buffer));
      len = recv_line(atom->soc, buffer, sizeof(buffer)-1);
      if(!len)
      {
#ifdef ENABLE_SAVE_TESTS
       if(preferences_save_session(preferences))save_tests_host_done(globals, atom->name);
#endif       
       attack_atom_remove(atoms, atom->name);
      }
      else
      { 
       /*
        * Forward the results to the client
	*/
       if((soc2 >= 0) && (sock > 0))
       {
       n = 0;
       while(n < len)
       {
        int err = nsend(soc2, buffer+n, len - n , 0);
        if(err >= 0)
	  n += err;
	else
	  {
	    perror("nsend");
	    break;
	  }
        }
       }
       
#ifdef ENABLE_SAVE_KB
        /*
	 * Copy the message in the email we'll send to the admin
	 */
	 if(preferences_detached_scan(preferences))
		detached_copy_data(globals, estrdup(buffer), len);
#endif
		       
#ifdef ENABLE_SAVE_TESTS	
	if(preferences_save_session(preferences))save_tests_write_data(globals, estrdup(buffer));
	
#endif	

      /* 
       * send something to tell the son we read his message
       * this avoids us to be overwhelmed by messages coming
       * from each sons and filling our mbufs
       *
       */
 again:
       tv.tv_sec = 1;
       tv.tv_usec = 0;
       FD_ZERO(&wr);
       FD_SET(atom->soc, &wr);
       if(select(atom->soc+1, NULL, &wr,NULL, &tv) > 0)
       {
        if(send(atom->soc, ".", 1, 0)  < 0)
	{
	 if(errno != EPIPE) perror("send ");
	}
       }
       else 
        if(errno == EINTR)goto again;
       
       ret++;
      }
     }
     else 
      if((send(atom->soc, &dummy, 0, 0)<0))
      {
       struct arglist * preferences = arg_get_value(globals,"preferences");
       char * show = arg_get_value(preferences, "ntp_opt_show_end");
       if(show && !strcmp(show, "yes"))ntp_11_show_end(globals, atom->name);
#ifdef ENABLE_SAVE_TESTS      
       if(preferences_save_session(preferences))save_tests_host_done(globals, atom->name);
#endif       
       attack_atom_remove(atoms, atom->name);
      }
   atom = next;
  }
 } 
 else 
  usleep(1000);
 return ret;
}


int check_client_input(globals, soc, atoms)
 struct arglist * globals;
 int soc;
 struct attack_atom ** atoms;
{ 
 struct nessusd_threads ** threads = arg_get_value(globals, "threads");
 char buf[16384];
 char * t, * t2;
 bzero(buf, sizeof(buf));
 auth_gets(globals, buf, sizeof(buf) - 1);
 if(!strlen(buf))return(-1);

  if((t = strstr(buf, "STOP_ATTACK")))
  {  
    t2 = strstr(t, "<|> ");
    if(!t2)return(0);
    t2+=strlen("<|> ");
    t = strstr(t2, " <|>");
    if(!t)return(0);
    t[0] = 0;
    log_write("user %s : stopping attack against %s\n", 
    		(char*)arg_get_value(globals, "user"),
		t2);
    attack_atom_remove(atoms, t2);
    nessusd_thread_kill_by_name(threads, *threads, t2);
    ntp_1x_timestamp_host_scan_interrupted(globals, t2);
    ntp_11_show_end(globals, t2);
    t[0] = ' ';
    
   } else if((t = strstr(buf,"STOP_WHOLE_TEST"))){
        log_write("stopping the whole test (requested by client)");
        nessusd_thread_kill_all(threads);
        return(-2);
        }
  return 0;
 }





int
is_symlink(name)
 char * name;
{
#ifndef NESSUSNT
 struct stat sb;
 if(stat(name, &sb))return(0);
 return(S_ISLNK(sb.st_mode));
#else
 return(0);
#endif
}

void check_symlink(name)
 char * name;
{
 if(is_symlink(name))
 { 
  fprintf(stderr, "The file %s is a symlink -- can't continue\n", name);
  DO_EXIT(0);
 }
}

/*
 * Converts a hostnames arglist 
 * to a space delimited lists of hosts
 * in one string
 */
char * 
hosts_arglist_to_string(hosts)
 struct arglist * hosts;
{
 int num_hosts = 0;
 struct arglist * start = hosts;
 int hosts_len = 0;
 char * ret;

 while(hosts && hosts->next){
  if(hosts->value)
  {
    num_hosts++;
    hosts_len+=strlen(hosts->value);
  }
  hosts = hosts->next;
 }       
  
 ret = emalloc(hosts_len + 2 * num_hosts + 1);
 
 hosts = start;
 
 while(hosts && hosts->next) {
  if(hosts->value){
   strcat(ret, hosts->value);
   strcat(ret, " ");
  }
  hosts = hosts->next;
 }
return(ret);
} 

/*-----------------------------------------------------------------

		pid file management
		
-------------------------------------------------------------------*/

void
create_pid_file()
{
 FILE * f;
 char * fname = malloc(strlen(NESSUSD_STATEDIR) + strlen("/nessusd.pid") + 1);
 strcpy(fname, NESSUSD_STATEDIR);
 strcat(fname, "/nessusd.pid");
 
 f = fopen(fname, "w");
 if(!f)
 {
fprintf(stderr, "'%s'\n", fname);
  perror("create_pid_file() : open ");
  return;
 }
 fprintf(f, "%d\n", getpid());
 fclose(f);
 free(fname);
}

void
delete_pid_file()
{
 char * fname = malloc(strlen(NESSUSD_STATEDIR) + strlen("/nessusd.pid") + 1);
 strcpy(fname, NESSUSD_STATEDIR);
 strcat(fname, "/nessusd.pid");
 unlink(fname);
 free(fname);
}


/*
 * Returns a name suitable for a temporary file. 
 * This function ensures that this name is not taken
 * already.
 */
char*
temp_file_name()
{
 char* ret = emalloc(strlen(NESSUSD_STATEDIR)+strlen("tmp") + 40);
 int fd = - 1;
 do {
 if(fd > 0){
 	if(close(fd) < 0)
	 perror("close ");
	}
 sprintf(ret, "%s/tmp.%d-%d", NESSUSD_STATEDIR, getpid(), rand()%1024);
 fd = open(ret, O_RDONLY);
 } 
  while (fd >= 0);
  
 return ret;
}

 
 

/*---------------------------------------------------------------------

	Determines if a process is alive - as reliably as we can

-----------------------------------------------------------------------*/

int 
process_alive(pid)
 pid_t pid;
{
 int i, ret;
 if(!pid) 
  return 0;
 
 for(i=0,ret=1;(i<100) && (ret > 0);i++)
   ret = waitpid(pid, NULL, WNOHANG);
   
   
 return kill(pid, 0) == 0;
}
/*---------------------------------------------------------------------

	Determines if the client is still connected

	Returns <1> if the client is here
		<0> if it's not

-----------------------------------------------------------------------*/


int 
is_client_present(soc)
	int soc;
{
	fd_set  rd;
	struct timeval tv = {2,0};
	int m;

	stream_zero(&rd);
	m = stream_set(soc, &rd);
	if(select(m+1, &rd, NULL, NULL, &tv) > 0)
	{
		int len = -1;
		ioctl(nessus_get_socket_from_connection(soc), FIONREAD, &len);
		if(!len){
			log_write("Communication closed by client\n");
			return 0;
			}
	}
	return 1;
}
