#ifndef __NESSUSD_RTREE_H__
#define __NESSUSD_RTREE_H__


struct rtree {
	int 		id;
  	int 	        num_elems;
	int		allocated_elems;
	void *		data;
	struct rtree  ** elems;
	struct rtree  *  root;
};

#define RTREE_INVAL_NODE ((void*)-1)




struct rtree * rtree_node_new(struct rtree*, int);
int rtree_node_set_data(struct rtree*, void*);

struct rtree * rtree_node_new_with_data(struct rtree*, int, void*);


void * rtree_node_data(struct rtree*);
int rtree_node_size(struct rtree*);
int rtree_node_num_elems(struct rtree*);
struct rtree * rtree_node_get_nth_node(struct rtree*, int);
int rtree_insert(struct rtree*, struct rtree*);
void rtree_free(struct rtree*);
int rtree_node_depth(struct rtree*);
struct rtree * rtree_node_move_up(struct rtree*);
struct rtree * rtree_node_data_move_up(struct rtree*);
struct rtree* rtree_root(struct rtree*);



#endif
