/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * This module computes the hash of the plugins (and the hash of the
 * hashes of the plugins)
 *
 */

#include <includes.h>
#include "./md5.h"
#include "users.h"
#include "log.h"

static char *
file_hash(fname)
  char * fname;
{
 struct stat st;
 int fd = open(fname, O_RDONLY);
 char * content;
 if(fd < 0)
  return NULL;
  
 fstat(fd, &st);
 
 content = mmap(NULL, st.st_size, PROT_READ, MAP_PRIVATE,fd, 0);
 if(content &&
    (content != MAP_FAILED))
    {
     char * ret = md5sum(content, st.st_size);
     munmap(content, st.st_size);
     close(fd);
     return ret;
    }
 return NULL;
}


/*
 * Returns a hash of each plugin hash
 */
static void
dir_plugins_hash(ctx, dirname)
 md5_ctx * ctx;
 char * dirname;
{
 DIR * dir;
 struct dirent * dp;
 
 
 if(!dirname)
  return;
    
 dir = opendir(dirname);
 if(!dir)
 {
  log_write("plugins_hash(): could not open %s - %s\n",
  			dirname,
			strerror(errno));
  return;
 }
 

 while((dp = readdir(dir)))
 {
  char fullname[PATH_MAX + 1];
  char * tmp;
  if((strlen(dirname) + strlen(dp->d_name) + 1) >
     (sizeof(fullname) - 1))
     {
     log_write("plugins_hash(): filename too long\n");
     continue;
     }
   bzero(fullname, sizeof(fullname));
   strcat(fullname, dirname);
   strcat(fullname, "/");
   strcat(fullname, dp->d_name);
   tmp = file_hash(fullname);
   if(tmp)
    md5update(ctx, tmp, strlen(tmp));
   else
    {
     if(strcmp(dp->d_name, ".") &&
        strcmp(dp->d_name, ".."))log_write("Could not compute the md5 hash of %s\n", dp->d_name);
    }
   efree(&tmp);
  }
  closedir(dir);
}


/*
 * returns the hash of the hashes of the plugins in the
 * plugins dir + plugins in the user home dir
 */
char * 
plugins_hash(globals)
 struct arglist * globals;
{
 struct arglist * preferences = arg_get_value(globals,"preferences");
 char *dir  = arg_get_value(preferences, "plugins_folder");
 char *uhome;
 md5_ctx * ctx;
 char * ret;
 
 ctx = md5init();
 dir_plugins_hash(ctx, dir);
 uhome = user_home(globals);
 dir = emalloc(strlen(uhome) + strlen("/plugins") + 1);
 sprintf(dir, "%s/plugins", uhome);
 efree(&uhome);
 dir_plugins_hash(ctx, dir);
 efree(&dir);
 ret = md5final(ctx);
 md5free(ctx);
 return ret;
}


void
plugins_send_md5(globals)
 struct arglist * globals;
{
 struct arglist * plugins = arg_get_value(globals, "plugins");
 auth_printf(globals, "SERVER <|> PLUGINS_MD5\n");
 if(!plugins)
  return;
 while(plugins->next)
 {
  char * fname = arg_get_value(plugins->value, "full_name");
  struct arglist * args = arg_get_value(plugins->value, "plugin_args");
  int id = (int)arg_get_value(args, "ID");
  char * md5   = file_hash(fname);
  auth_printf(globals, "%d <|> %s\n", id, md5);
  efree(&md5);
  plugins = plugins->next;
 }
 auth_printf(globals, "<|> SERVER\n");
}
