/* Nessus
 * Copyright (C) 1999 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Old style nessus plugins, implemented as shared libraries.
 *
 */

#include <includes.h>
#include "pluginload.h"
#include "threads.h"
#include "log.h"
#include "preferences.h"


#ifdef HAVE_SHL_LOAD	/* this is HP/UX */
ext_library_t dlopen(name)
 char* name;
{
 return (ext_library_t)shl_load(name, BIND_IMMEDIATE|BIND_VERBOSE|BIND_NOSTART, 0L);
}

void * 
dlsym(lib, name)
 shl_t lib;
 char * name;
{
 void* ret;
 int status;
 status = shl_findsym((shl_t *)&lib, name, TYPE_PROCEDURE, &ret);
 if((status == -1) && (errno == 0))
 {
  status = shl_findsym((shl_t *)&lib, name, TYPE_DATA, &ret);
 }
 
 return (status == -1 ) ? NULL : ret;
}

void
dlclose(x)
 shl_t * x;
{
 shl_unload(x);
}

char*
dlerror()
{
 return strerror(errno);
}

#else /* HAVE_SHL_LOAD */
#ifdef HAVE_NSCREATEOBJECTFILEIMAGEFROMFILE /* Darwin */
#ifdef HAVE_DL_LIB /* dlcompat is installed - not good */
#define dlopen macosx_dlopen
#define dlsym macosx_dlsym
#define dlclose macosx_dlclose
#define dlerror macosx_dlerror
#undef HAVE_DL_LIB
#endif
#include <mach-o/dyld.h>

ext_library_t
dlopen(name)
 char* name;
{
 NSObjectFileImage ofile;
 NSSymbol nsSymbol;
 
 if(NSCreateObjectFileImageFromFile(name, &ofile) != NSObjectFileImageSuccess)
 {
  fprintf(stderr, "NSCreateObjectFileImageFromFile(%s) failed\n", name);
  return NULL;
 }

 return NSLinkModule(ofile, name, NSLINKMODULE_OPTION_PRIVATE|
				  NSLINKMODULE_OPTION_BINDNOW);
}

void * 
dlsym(lib, name)
 void* lib;
 char * name;
{
 NSSymbol nsSymbol = NSLookupSymbolInModule((NSModule)lib, name); 
 if(nsSymbol == NULL)
 {
  /* fprintf(stderr, "NSLookupSymbolInModule(%x, %s) failed\n", lib, name); */
  return NULL;
 }
 return NSAddressOfSymbol(nsSymbol);
}

void
dlclose(x)
 void * x;
{
 NSUnLinkModule((NSModule)(x), NSUNLINKMODULE_OPTION_NONE);
}

char*
dlerror()
{
 return strerror(errno);
}
#endif /* Darwin */
#endif

/*
 *  Initialize this class
 */
pl_class_t* nes_plugin_init(struct arglist* prefs, struct arglist* args) {
    return &nes_plugin_class;
}

/*
 * add *one* .nes (shared lib) plugin to the server list
 */
struct arglist * 
nes_plugin_add(folder, name, plugins, preferences)
     char * folder;
     char * name;
     struct arglist * plugins;
     struct arglist * preferences;
{
 ext_library_t ptr = NULL; 
 char * fullname = NULL;
 struct arglist * plugin = NULL;
 
#ifndef NESSUSNT
  fullname = emalloc(strlen(folder)+strlen(name)+2);
  sprintf(fullname, "%s/%s", folder, name);
#else
 fullname = emalloc(strlen(name)+1);
 strncpy(fullname, name, strlen(name));
#endif /* not defined(NESSUSNT) */

  if((ptr = LOAD_LIBRARY(fullname))==NULL){
    log_write("Couldn't load %s\n", name);
#ifndef NESSUSNT
    log_write("Error : %s\n", LIB_LAST_ERROR());
#else
    log_write("Error : %d\n", LIB_LAST_ERROR());
#endif
  }
  else {
    plugin_init_t  f_init;
    struct arglist * args;
    plugin = emalloc(sizeof(struct arglist));   
    if((f_init = (plugin_init_t)LOAD_FUNCTION(ptr, "plugin_init")) ||
    	(f_init = (plugin_init_t)LOAD_FUNCTION(ptr, "_plugin_init")))
      {
	int e;
      	args = emalloc(sizeof(struct arglist));
      	arg_add_value(args, "preferences", ARG_ARGLIST, -1, (void*)preferences);
      	e = (*f_init)(args);
	if(e >= 0 && arg_get_value(args, "NAME"))
	{
 	 arg_add_value(plugin, "plugin_args", ARG_ARGLIST, -1, (void *)args);
         arg_add_value(plugin, "full_name", ARG_STRING, -1, fullname);
 	 plug_set_launch(args, 0);
 	 arg_add_value(plugins, name, ARG_ARGLIST, -1, (void *)plugin);
	}
      }
    else log_write("Couldn't find the entry point in %s [%s]\n", name,LIB_LAST_ERROR());
    CLOSE_LIBRARY(ptr);
  }
 return(plugin);
}


int
nes_plugin_launch(globals, plugin, hostinfos, preferences, kb, name, soc)
	struct arglist * globals;
	struct arglist * plugin;
	struct arglist * hostinfos;
	struct arglist * preferences;
	struct arglist * kb; /* knowledge base */
	char * name;
	int soc;
{
 struct arglist * args;
 short* ports = arg_get_value(globals, "ports");
 int ports_num =(int)arg_get_value(globals, "ports_num");
 nthread_t module;
 plugin_run_t func = NULL;
 ext_library_t ptr = NULL;
 
 ptr = LOAD_LIBRARY(name);
 if(!ptr)
 	return -1;
 func = (plugin_run_t)LOAD_FUNCTION(ptr, "plugin_run");
 if(!func)func = (plugin_run_t)LOAD_FUNCTION(ptr, "_plugin_run");
 if(!func){
 	log_write("no 'plugin_run()' function in %s\n", name);
	return -1;
	}

 args = arg_get_value(plugin, "plugin_args");
 arg_add_value(args, "globals", ARG_ARGLIST, -1, globals);
 arg_add_value(args, "HOSTNAME", ARG_ARGLIST, -1, hostinfos);
 arg_add_value(args, "ports", ARG_PTR, -1, ports);
 arg_add_value(args, "ports_num", ARG_INT, sizeof(int), (void*)ports_num);
 arg_set_value(args, "preferences", -1, preferences);
 arg_add_value(args, "pipe", ARG_INT, sizeof(int), (void*)soc);
 arg_add_value(args, "key", ARG_ARGLIST, -1, kb);
 module = create_thread((void*)func, args, (struct arglist*)-1);
 CLOSE_LIBRARY(ptr);
 return module;
}


pl_class_t nes_plugin_class = {
    NULL,
    ".nes",
    nes_plugin_init,
    nes_plugin_add,
    nes_plugin_launch,
};
