/* Nessus
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * nasl_plugins.c : Launch a NASL script
 *
 */

#include <includes.h>
#include <nessus/nasl.h>
#include "pluginload.h"
#include "preferences.h"
#include "threads.h"
/*
 *  Initialize the nasl system
 */
static pl_class_t* nasl_plugin_init(struct arglist* prefs,
				    struct arglist* nasl) {
    return &nasl_plugin_class;
}



static void nasl_thread(struct arglist *);

/*
 *  Add *one* .nasl plugin to the plugin list
 */
static struct arglist *
nasl_plugin_add(folder, name, plugins, preferences)
     char * folder;
     char * name;
     struct arglist * plugins;
     struct arglist * preferences;
{
 char * fullname = NULL;
 harglst * nasl = init_nasl(preferences_get_checks_read_timeout(preferences));
 harglst *  nasl_globals;
 harglst *  nasl_types;
 struct arglist *plugin_args;
 struct arglist * plugin;
 char * lang = "english";
 
 nasl_globals = harg_get_harg(nasl, "variables");
 nasl_types = harg_get_harg(nasl, "variables_types");
 fullname = emalloc(strlen(folder)+strlen(name)+2);
 sprintf(fullname, "%s/%s", folder, name);

 if(arg_get_type(preferences, "language")>=0)
  lang = arg_get_value(preferences, "language");

 plugin_args = emalloc(sizeof(struct arglist));
 
 harg_add_string(nasl_globals, "description", "1");
 harg_add_int(nasl_types, "description", VAR_STR|STR_ALL_DIGIT);
			    
 harg_add_string(nasl_globals, "language", lang);
 harg_add_int(nasl_types, "language",VAR_STR);
 
 harg_add_ptr(nasl, "script_infos", plugin_args);
 
 
 arg_add_value(plugin_args, "preferences", ARG_ARGLIST, -1, (void*)preferences);
 
 execute_script(nasl, fullname); /* execute the script */

 plugin = emalloc(sizeof(struct arglist));
 arg_add_value(plugin, "plugin_args", ARG_ARGLIST, -1, (void *)plugin_args);
 arg_add_value(plugin, "full_name", ARG_STRING, -1, fullname);
 plug_set_launch(plugin_args, 0);
 arg_add_value(plugins, name, ARG_ARGLIST, -1, (void *)plugin);
 nasl_exit(nasl);
 return(plugin);
}

/*
 * Launch a NASL plugin
 */
int
nasl_plugin_launch(globals, plugin, hostinfos, preferences, kb, name, soc)
 	struct arglist * globals;
	struct arglist * plugin;
	struct arglist * hostinfos;
	struct arglist * preferences;
	struct arglist * kb;
	char * name;
	int soc;
{
 struct arglist * args;
 
 int timeout;
 int category = 0;
 nthread_t module;
 struct arglist * d = emalloc(sizeof(struct arglist));
 short* ports = arg_get_value(globals, "ports");
 int ports_num = (int)arg_get_value(globals, "ports_num");
 
 args = arg_get_value(plugin, "plugin_args");
 

 
 arg_add_value(args, "HOSTNAME", ARG_ARGLIST, -1, hostinfos);
 if(arg_get_value(args, "globals"))
   arg_set_value(args, "globals", -1, globals);
 else    
   arg_add_value(args, "globals", ARG_ARGLIST, -1, globals);
 
 
 arg_add_value(args, "ports", ARG_PTR, -1, ports);
 arg_add_value(args, "ports_num", ARG_INT, sizeof(int), (void*)ports_num);
 arg_set_value(args, "preferences", -1, preferences);
 arg_add_value(args, "pipe", ARG_INT, sizeof(int), (void*)soc);
 arg_add_value(args, "key", ARG_ARGLIST, -1, kb);

 arg_add_value(d, "args", ARG_ARGLIST, -1, args);
 arg_add_value(d, "name", ARG_STRING, -1, name);
 
 category = (int)arg_get_value(args, "CATEGORY");
 timeout = preferences_plugin_timeout(preferences,(int)arg_get_value(args, "ID"));
 if(!timeout)
 {
  if(category == ACT_SCANNER)timeout = -1;
  else timeout = preferences_plugins_timeout(preferences);
 }

 module = create_thread((void*)nasl_thread, d, (struct arglist*)-1); 
 arg_free(d);
 return module;
}


static void 
nasl_thread(g_args) 
 struct arglist * g_args;
{
 struct arglist * args = arg_get_value(g_args, "args");
 struct arglist * globals = arg_get_value(args, "globals");
 struct arglist * preferences = arg_get_value(globals, "preferences");
 char * name = arg_get_value(g_args, "name");
 harglst * nasl;
 harglst * variables;
 harglst * types;
 
#ifdef RLIMIT_RSS
 {
 struct rlimit rlim;
 getrlimit(RLIMIT_RSS, &rlim);
 rlim.rlim_cur = 1024*1024*20;
 rlim.rlim_max = 1024*1024*20;
 setrlimit(RLIMIT_RSS, &rlim);
 }
#endif

#ifdef RLIMIT_AS
 {
 struct rlimit rlim;
 getrlimit(RLIMIT_AS, &rlim);
 rlim.rlim_cur = 1024*1024*20;
 rlim.rlim_max = 1024*1024*20;
 setrlimit(RLIMIT_AS, &rlim);
 }
#endif
 nasl = init_nasl(preferences_get_checks_read_timeout(preferences));
 variables = harg_get_harg(nasl, "variables");
 types = harg_get_harg(nasl, "variables_types");
 
 harg_add_string(variables, "description", "0");
 harg_add_int(types,"description", VAR_STR|STR_ALL_DIGIT);
 
 harg_add_ptr(nasl, "script_infos", args);
 execute_script(nasl, name);
 nasl_exit(nasl);
}


pl_class_t nasl_plugin_class = {
    NULL,
    ".nasl",
    nasl_plugin_init,
    nasl_plugin_add,
    nasl_plugin_launch,
};
