/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Attack.c : 
 *  launch the plugins, and manages the multithreading 
 *
 */
 
#include <includes.h>
#include "attack.h"
#include "log.h"
#include "hosts_gatherer.h"
#include "sighand.h"
#include "rules.h"
#include "auth.h"
#include "threads.h"
#include "comm.h" 
#include "rtree.h"
#include "utils.h"
#include "preferences.h"
#include "plugs_deps.h"
#include "ntp.h"
#include "ntp_11.h"
#include "pluginload.h"
#include "pluginlaunch.h"
#include "plugs_req.h"
#include "save_tests.h"
#include "save_kb.h"
#include "detached.h"

extern int Delay_between_tests;
extern u_short * getpts(char *);

/*******************************************************

		PRIVATE FUNCTIONS
		
********************************************************/


static struct nessusd_threads ** Threads  = NULL;
static void
attack_sigterm()
{
 if(Threads)
  nessusd_thread_kill_all(Threads);

 wait_for_children();
}


static void 
arg_addset_value(arg, name, type, len, value)
 struct arglist *arg;
 char * name;
 int type, len;
 void * value;
{
 if(arg_get_type(arg, name) < 0)
  arg_add_value(arg, name, type, len, value);
 else
  arg_set_value(arg, name, len, value);
}



/*-------------------------------------------------------

	Init. an arglist which can be used by 
	the plugins from an hostname and its ip
	
--------------------------------------------------------*/	
static struct arglist * 
attack_init_hostinfos(mac, hostname, ip)
     char * mac;
     char * hostname;
    struct in_addr * ip;
{
  struct arglist * hostinfos;
  struct arglist * ports;
  struct in_addr addr;
  
  hostinfos = emalloc(sizeof(struct arglist));
  if(inet_aton(hostname, &addr) != 0)
  {
   char * f = (char*)hg_get_name_from_ip(addr);
   arg_add_value(hostinfos, "FQDN", ARG_STRING, strlen(f), estrdup(f));
   free(f);
  }
  else
   arg_add_value(hostinfos, "FQDN", ARG_STRING, strlen(hostname), hostname);
   
   
  if(mac)
  {
  	arg_add_value(hostinfos, "NAME", ARG_STRING, strlen(mac), mac);
	arg_add_value(hostinfos, "MAC", ARG_STRING, strlen(mac), mac);
  }
  else
  	arg_add_value(hostinfos, "NAME", ARG_STRING, strlen(hostname), hostname);
	
  arg_add_value(hostinfos, "IP", ARG_PTR, sizeof(struct in_addr), ip);
  ports = emalloc(sizeof(struct arglist));
  arg_add_value(hostinfos, "PORTS", ARG_ARGLIST, sizeof(struct arglist), ports);
  return(hostinfos);
}

/*--------------------------------------------------------
	
		 Return our user name
 
 ---------------------------------------------------------*/
 
static char *
attack_user_name(globals)
 struct arglist * globals;
{
 return (char *)arg_get_value(globals, "user");
}





#if 0
/*---------------------------------------------------------

	Wait if 'old' and 'new' have some port in common
	
----------------------------------------------------------*/
static int
attack_wait_if_similar_plugins(globals, old, new, preferences)
 struct arglist * globals, *old, *new, *preferences;
{
 int cat_old = 0;
 return 0;
 
 if(old)cat_old =  (int)arg_get_value(arg_get_value(old->value, "plugin_args"), 
	 			      "CATEGORY");
 if((old &&  
    Delay_between_tests &&
    requirements_common_ports(new->value, 
    			  old->value)) ||
    (cat_old == ACT_SCANNER))			
    {
    if(preferences_log_whole_attack(preferences))
    log_write("user %s : Two consecutive attacks on the same port. Sleeping %d second%s",
	  		attack_user_name(globals),
			Delay_between_tests, 
			(Delay_between_tests==1) ?"":"s");    
    sleep(Delay_between_tests);
  }
  return 0;
}
#endif



static int
launch_plugin(globals, plugins, hostname, cur_plug, num_plugs, key, hostinfos, portsinfos, new_kb, type)
 struct arglist * globals;
 struct arglist * plugins;
 char * hostname;
 int *cur_plug, num_plugs;
 struct arglist * key;
 struct arglist * hostinfos;
 struct arglist * portsinfos;
 int new_kb, type;
{
  struct arglist * preferences = arg_get_value(globals,"preferences");
  char * name;
  int optimize = preferences_optimize_test(preferences);
  int category = (int)arg_get_value(arg_get_value(plugins->value, "plugin_args"), 
	 			     "CATEGORY");
      
  name = (char*)arg_get_value(plugins->value, "full_name");
  if(plug_get_launch(plugins->value) || (category == ACT_SETTINGS)) /* can we launch it ? */
  {
   char * error;
   
   pl_class_t * cl_ptr = arg_get_value(plugins->value, "PLUGIN_CLASS");
   
   
   if(category != type)
      return 0;
  
  if(preferences_safe_checks_enabled(preferences) && 
  	(category == ACT_DESTRUCTIVE_ATTACK ||
	 category == ACT_DENIAL))
	 	{
		log_write("user %s : Not launching %s against %s %s (this is not an error)\n",
	       			attack_user_name(globals),
				plugins->name, 
				hostname, 
				"because safe checks are enabled");
		return 0;
		}
		
   comm_send_status(globals, hostname, "attack", (*cur_plug)++, num_plugs);


    if(save_kb(globals))
    {
     int id = (int)arg_get_value(arg_get_value(plugins->value, "plugin_args"), "ID");
     char asc_id[30];
	 
     
     /*
      * Does our user want a differential scan only ?
      */
      if(diff_scan(globals))
        diff_scan_enable(plugins->value);
	 
	 
	 			     
	 sprintf(asc_id, "Launched/%d", id);
	 if(arg_get_value(key, asc_id) &&
	    !save_kb_replay_check(globals, category))
	  {
	   /* 
	    * XXX determine here if we should skip
	    * ACT_SCANNER, ACT_GATHER_INFO, ACT_ATTACK and ACT_DENIAL
	    */
	   if(preferences_log_whole_attack(preferences))
	    log_write("user %s : Not launching %s against %s %s (this is not an error)\n",
	       			attack_user_name(globals),
				plugins->name, 
				hostname, 
				"because it has already been launched in the past");
				
	   return 0;
	  }
	  else {
	  	arg_addset_value(key, asc_id, ARG_INT, sizeof(int), (void*)1);
		save_kb_write_int(globals, hostname, asc_id,  1);
		}
       }	     
	
	 
	 if(!optimize || 
	   !(error = requirements_plugin(key, plugins,portsinfos, preferences)))
	 {
	  int pid;
	  
	 /*
	  * Start the plugin
	  */
	 pid = plugin_launch(globals, plugins, hostinfos, preferences, key, name, cl_ptr);
		
		
		 
	 if(preferences_log_whole_attack(preferences))
	 	log_write("user %s : launching %s against %s [%d]\n", 
	 				attack_user_name(globals),
					plugins->name, 
					hostname,
					pid);
					
	 	     
	 /*
	  * Stop the test if the host is 'dead'
	  */	 
        if(arg_get_value(key, "Host/dead") ||
	   arg_get_value(key, "Host/ping_failed"))
	{
	  log_write("user %s : The remote host (%s) is dead\n",
	  				attack_user_name(globals),
	  				hostname);
	  pluginlaunch_stop();		
	  if(new_kb)save_kb_close(globals, hostname);	
	  if(arg_get_value(key, "Host/ping_failed"))
	  {
	   save_kb_restore_backup(globals, hostname);
	  }						
	  return -1;
	}
       }
       
       else /* requirements_plugin() failed */
	  {
	   if(preferences_log_whole_attack(preferences))
	    log_write("user %s : Not launching %s against %s %s (this is not an error)\n",
	       			attack_user_name(globals),
				plugins->name, 
				hostname, 
				error);
	
	    efree(&error);	
	  }
      } /* if(plugins->launch) */
      return 0;
}

/*--------------------------------------------------------
	
	          Attack _one_ host

----------------------------------------------------------*/	
static void 
attack_host      (globals, 
		  hostinfos, 
		  plugins, 
		  hostname, 
		  port_range, 
		  hosts_list)
     
     
     struct arglist * globals;
     struct arglist * hostinfos;
     struct arglist * plugins;
     char * hostname;
     char * port_range;
     struct arglist * hosts_list;
{ 

  /*
   * Used for the status
   */
  int num_plugs = 0;
  int cur_plug = 1;
  int i;
 
  struct arglist * preferences = arg_get_value(globals,"preferences");
  struct arglist * key;
  struct arglist * portsinfos = emalloc(sizeof(struct arglist));
  struct rtree   * splugs;
  int new_kb = 0;
  int kb_restored = 0;
  if(save_kb(globals))
  {
   if(
      save_kb_exists(globals, hostname) &&
      save_kb_pref_restore(globals)
      )
   {
    save_kb_backup(globals, hostname);
    key = save_kb_load_kb(globals, hostname);
    /*
     * XXXX
     * - Mark the KB as restored
     *
     * - Should send a warning telling that no port scan has
     *   been fully performed this time
     */
    kb_restored = 1; 
  }
  else 
  {
   save_kb_new(globals, hostname);
   key = emalloc(sizeof(struct arglist));
   new_kb = 1;
   }
  
  /* XXX */
  arg_add_value(globals, "CURRENTLY_TESTED_HOST", ARG_STRING, strlen(hostname), hostname);
 }
 else key = emalloc(sizeof(struct arglist));
  
  
  arg_add_value(key, "hosts", ARG_ARGLIST, -1, hosts_list);
  
  splugs = deps_plugins_sort(plugins, preferences_autoload_dependencies(preferences));
  num_plugs = get_active_plugins_number(splugs);
 
  arg_add_value(portsinfos, "ports", ARG_PTR, -1, arg_get_value(globals,"ports"));
  arg_add_value(portsinfos, "ports_num", ARG_INT, -1, arg_get_value(globals,
  								"ports_num"));
  arg_add_value(portsinfos, "key", ARG_ARGLIST, -1, key);
  
  
  
  /* launch the plugins */
  pluginlaunch_init(globals);
  for (i = ACT_FIRST; i <= ACT_LAST; i++)
  {
   struct arglist * plugin;
   
   /*
    * Scanners (and DoS) must not be run in parrallel
    */
   if((i == ACT_SCANNER) ||
      (i == ACT_DENIAL))
      pluginlaunch_disable_parrallel_checks();
   else
      pluginlaunch_enable_parrallel_checks();
      
   splugs = rtree_root(splugs);
   plugin = rtree_node_data(splugs);
   if(plugin)
    {
      if(launch_plugin(globals, 
      		    plugin, 
		    hostname, 
		    &cur_plug, 
		    num_plugs, 
		    key, 
		    hostinfos, 
		    portsinfos, 
		    new_kb,
		    i) < 0)
		    {
		     /* 
		      * Remote host died
		      */
		      goto host_died;
		    }
      }
   pluginlaunch_wait();   
   for(;;)
   {
   struct rtree * next_layer = rtree_node_get_nth_node(splugs, 0);
   int j, l = rtree_node_num_elems(splugs);
   for(j=0;j<l;j++)
   {
    struct rtree * node;
    struct arglist * plugin;
    node = rtree_node_get_nth_node(splugs, j);
    plugin = node ? rtree_node_data(node) : NULL;
   
    if(plugin)
    {
      if(launch_plugin(globals, 
      		    plugin, 
		    hostname, 
		    &cur_plug, 
		    num_plugs, 
		    key, 
		    hostinfos, 
		    portsinfos, 
		    new_kb,
		    i)  < 0)
		    {
		     /*
		      * Remote host died
		      */
		     goto host_died;
		    }
      }
    }
    pluginlaunch_wait();
    if(next_layer && next_layer != RTREE_INVAL_NODE)splugs = next_layer;
    else {
	break;
	}
   }
  }
  pluginlaunch_wait();
host_died:  
  pluginlaunch_stop();
  rtree_free(rtree_root(splugs));
  if(new_kb)save_kb_close(globals, hostname);
  efree(&portsinfos);
}

/*-----------------------------------------------------------------

  attack_start : set up some data and jump into
  attack_host()

 -----------------------------------------------------------------*/
static void
attack_start(args)
  struct arglist * args;
{
 struct linger linger;
 struct arglist * globals = arg_get_value(args, "globals");
 char * hostname = arg_get_value(args, "hostname");
 char * mac = arg_get_value(args, "host_mac_addr");
 struct arglist * plugs = arg_get_value(args, "plugins");
 char * port_range = arg_get_value(args, "port_range");
 struct in_addr * hostip = arg_get_value(args, "hostip");
 struct arglist * hosts_list = arg_get_value(args, "hosts_list");
 struct arglist * hostinfos;
 
 struct arglist * preferences = arg_get_value(globals,"preferences");
 char * non_simult = arg_get_value(preferences, "non_simult_ports");
 int thread_socket = (int)arg_get_value(globals, "thread_socket");
 int soc;
 struct arglist * new_plugs = NULL;
 struct attack_atom ** atoms = arg_get_value(args, "atoms");
 struct timeval then, now;

 gettimeofday(&then, NULL);
 attack_atom_free_others(atoms, hostname);

 if(!non_simult){
        non_simult = estrdup("139");
 	arg_add_value(preferences, "non_simult_ports", ARG_STRING, strlen(non_simult), non_simult);
	}
 arg_add_value(preferences, "non_simult_ports_list", ARG_ARGLIST, -1, (void*)list2arglist(non_simult));
 /*
  * Options regarding the communication with out father
  */
 linger.l_onoff = 1;
 linger.l_linger = 60;
 setsockopt(thread_socket, SOL_SOCKET, SO_LINGER, &linger, sizeof(linger));
 nessus_deregister_connection((int)arg_get_value(globals, "global_socket"));
 arg_set_value(globals, "global_socket", -1, (void*)thread_socket);
 
 /*
  * Wait for the server to confirm it read our data
  * (prevents client desynch)
  */
 arg_add_value(globals, "confirm", ARG_INT, sizeof(int), (void*)1);
 
 soc = thread_socket;
 hostinfos = attack_init_hostinfos(mac, hostname,hostip);
 if(mac)
  hostname = mac;
  
#ifndef USE_FORK_THREADS
   new_plugs = emalloc(sizeof(struct arglist));
   arg_dup(new_plugs, plugs);
#else
    new_plugs = plugs;
#endif
  plugins_set_socket(plugs, soc);
  ntp_1x_timestamp_host_scan_starts(globals, hostname);
  attack_host(globals, hostinfos, new_plugs, hostname, port_range, hosts_list);
  if(preferences_ntp_show_end(preferences))ntp_11_show_end(globals, hostname);
  ntp_1x_timestamp_host_scan_ends(globals, hostname);
  gettimeofday(&now, NULL);
  if(now.tv_usec < then.tv_usec)
  {
   then.tv_sec ++;
   now.tv_usec += 1000000;
  }
  log_write("Finished testing %s. Time : %ld.%.2ld secs\n",
  		hostname,
  		now.tv_sec - then.tv_sec,
		(now.tv_usec - then.tv_usec) / 10000);
  shutdown(soc, 2);
  close(soc);
  
}

/*******************************************************

		PUBLIC FUNCTIONS
		
********************************************************/


/*------------------------------------------------

   This function attacks a whole network
 		
 -----------------------------------------------*/
int 
attack_network(globals)
    struct arglist * globals;
{
  int max_hosts			= 0;
  int num_tested		= 0;
  int host_pending		= 0;
  int num_threads		= 0;
  char * hostname 		= NULL;
  struct in_addr host_ip	= {0};
  char * port_range		= NULL;
  int hg_flags			= 0;
  struct hg_globals * hg_globals = NULL;
  int global_socket		= -1;
  struct arglist * preferences  = NULL;
  struct arglist * plugins      = NULL;
  struct arglist * hosts_list   = NULL;
  struct attack_atom ** atoms   = NULL;
  ntp_caps* caps		= NULL;
  struct nessusd_threads ** threads = NULL;
  struct nessus_rules *rules	= NULL;
  struct arglist * rejected_hosts =  NULL;
  unsigned short * ports	= NULL;
  int data			= 0;
  int restoring    = 0;
  harglst * tested = NULL;
  int  save_session= 0;  
  int continuous   = 0;
  int detached     = 0;
  hargwalk *  hw;
  harglst * files;
  char * key;
  struct rtree * splugs;
  int return_code = 0;
  
  preferences    = arg_get_value(globals, "preferences");
  detached = preferences_detached_scan(preferences);
  if(detached)
  {
   char *email;
   
   detached_new_session(globals, arg_get_value(preferences, "TARGET"));
   arg_addset_value(preferences, "ntp_keep_communication_alive", ARG_STRING, 0, NULL);
   
   /* 
    * Tell the client that the scan is finished (actually, we will
    * work hard to test the network, but this lazy client has the right
    * to get some rest...
    */
   log_write("user %s : running a detached scan\n", (char*)arg_get_value(globals, "user"));
   global_socket = (int)arg_get_value(globals, "global_socket");
   comm_terminate(globals);
   close_stream_connection(global_socket);
   global_socket = -1;
   arg_set_value(globals, "global_socket", sizeof(int), (void*)global_socket);
   
   nessus_signal(SIGTERM, attack_sigterm);
   
start_attack_network:
   if((email = preferences_detached_scan_email(preferences)))
   {
    /*
     * The user wants to receive the results by e-mail.
     */
    if(detached_setup_mail_file(globals, email))
    {
     /*
      * Could not create the file to store our data
      */
     close_stream_connection(global_socket);
     return -1;
    }
   }
   else arg_addset_value(globals, "detached_scan_email_address", ARG_STRING, 0, NULL);
  }  
  num_tested = 0;
  num_threads = 0;
  
  global_socket  = (int)arg_get_value(globals, "global_socket");
 
  plugins        = arg_get_value(globals, "plugins");
  hosts_list     = emalloc(sizeof(struct arglist));
  atoms          = attack_atom_new();
  caps           = arg_get_value(globals, "ntp_caps");
  rules          = arg_get_value(globals, "rules");
  rejected_hosts = emalloc(sizeof(struct arglist));
  
  if(detached)
    continuous = preferences_continuous_scan(preferences);
  
  save_session = preferences_save_session(preferences);
  if(continuous)
   restoring = 0;
  else
   restoring = ((int)arg_get_value(globals, "RESTORE-SESSION") == 1);
   
  if(restoring)tested = arg_get_value(globals, "TESTED_HOSTS");
  if(save_session)save_tests_init(globals);  


  hostname = arg_get_value(preferences, "TARGET");
  if(!hostname){
  	log_write("%s : TARGET not set ?!", 
			attack_user_name(globals));
	EXIT(1);
	}		
  
  if(port_range)efree(&port_range);
  
  port_range = arg_get_value(preferences, "port_range");
  if(!port_range||!strlen(port_range))port_range = estrdup("1-15000");
  else port_range = estrdup(port_range);
  
  if(strcmp(port_range, "-1"))
  {
   int num = 0;
   int i = 0;
   if(ports)efree(&ports);
   ports = (unsigned short*)getpts(port_range);
   if(!ports){
   	auth_printf(globals, "SERVER <|> ERROR <|> Invalid port range <|> SERVER\n");
	return -1; 
	}
   for(i=0;ports[i];i++,num++);
   if(arg_get_value(globals, "ports"))
    arg_set_value(globals, "ports", -1, ports);
   else
    arg_add_value(globals, "ports", ARG_PTR,-1, ports);
    
   if(arg_get_value(globals, "ports_num"))
    arg_set_value(globals, "ports_num", sizeof(int),  (void*)num);
   else
    arg_add_value(globals, "ports_num", ARG_INT, sizeof(int), (void*)num);
  }
  /*
   * Initialization of the attack
   */
   
  if(caps->ntp_11)
  {
  splugs = deps_plugins_sort(plugins, preferences_autoload_dependencies(preferences));
  send_plugin_order(globals, splugs);
  rtree_free(rtree_root(splugs));
  }
  hg_flags = preferences_get_host_expansion(preferences);

  max_hosts = get_max_hosts_number(preferences);
  if(!restoring)
  {
  log_write("user %s starts a new attack. Target(s) : %s, with max_hosts = %d\n",
			 attack_user_name(globals), 
			 hostname,
			 max_hosts);

  }
  else
  {
   log_write("user %s restores session %s, with max_hosts = %d\n",
   			attack_user_name(globals),
			(char*)arg_get_value(globals, "RESTORE-SESSION-KEY"),
			max_hosts);
			
   save_tests_playback(globals, arg_get_value(globals, "RESTORE-SESSION-KEY"),tested);
  }
  
  			 
  /* 
   * Initialize the hosts_gatherer library 
   */
   			  
  hg_globals = hg_init(hostname, hg_flags);
  hostname = hg_next_host(hg_globals,&host_ip);
  if(tested)
   while(hostname && 
         harg_get_int(tested, hostname)){
	 		efree(&hostname);
			hostname = hg_next_host(hg_globals, &host_ip);
			}
  if(hostname)
  {			 
   Threads = threads = nessusd_threads_init();
   if(arg_get_value(globals, "threads"))
    arg_set_value(globals, "threads", -1, threads);
   else
    arg_add_value(globals, "threads", ARG_PTR, -1, threads);
  
 
  
  /*
   * Start the attack !
   */
   
#if 0
   if(arg_get_value(globals, "client_socket"))
    arg_set_value(globals, "client_socket", sizeof(int), (void*)global_socket);
   else
    arg_add_value(globals, "client_socket", ARG_INT, sizeof(int), (void*)global_socket);       
#endif   
   if(arg_get_value(globals, "father"))
    arg_set_value(globals, "father", sizeof(int), (void*)getpid());
   else
    arg_add_value(globals, "father", ARG_INT, sizeof(int), (void*)getpid());
   
   
   while(hostname)
    {
      nthread_t pid;
      
      
   /*
    * nessusd offers the ability to either test
    * only the hosts we tested in the past, or only
    * the hosts we never tested (or both, of course)
    */
   if(save_kb(globals))
    {
    if(save_kb_pref_tested_hosts_only(globals))
    {
    if(!save_kb_exists(globals, hostname))
     {
      log_write("user %s : not testing %s because it has never been tested before\n",
      		 (char*)arg_get_value(globals, "user"), 
		 hostname);
      efree(&hostname);
      hostname = hg_next_host(hg_globals, &host_ip);
      continue;
     }
   }
   else if(save_kb_pref_untested_hosts_only(globals))
   {
    /* XXX */
    if(save_kb_exists(globals, hostname))
    {
     log_write("user %s : not testing %s because it has already been tested before\n", 
     			(char*)arg_get_value(globals, "user"), 
			hostname);
     efree(&hostname);			
     hostname = hg_next_host(hg_globals, &host_ip);
     continue;
    }
   }
  }

      host_pending = 0 ;
      if(CAN_TEST(get_host_rules(rules, host_ip,32))) /* do we have the right to test this host ? */ 
      {
      
	  if(num_threads < max_hosts)
	    {
             struct arglist * arglist = emalloc(sizeof(struct arglist));
	     struct in_addr * ia = emalloc(sizeof(ia));
	     int s[2] = {-1,-1};
	     char * MAC = NULL;
	     int mac_err = -1;
	     
	     
	    if(preferences_use_mac_addr(preferences) &&
	        is_local_ip(host_ip))
	     {
	      mac_err = get_mac_addr(host_ip, &MAC);
	      if(mac_err > 0)
	      {
	       /* remote host is down */
	       hostname = hg_next_host(hg_globals, &host_ip);
	       continue;
	      }
	     }
	     
	     if(!socketpair(AF_UNIX, SOCK_STREAM, 0, s))
	     {
	      if(arg_get_value(globals, "thread_socket"))
	       arg_set_value(globals, "thread_socket", sizeof(int), (void*)s[0]);
	      else
	       arg_add_value(globals, "thread_socket", ARG_INT, sizeof(int), (void*)s[0]);
	      }
	     else perror("socketpair ");	
	     arg_add_value(hosts_list, hostname, ARG_INT, -1, (void *)1);
             arg_add_value(arglist, "globals", ARG_ARGLIST, -1, globals);
             arg_add_value(arglist, "hostname", ARG_STRING, -1, hostname);
	     ia->s_addr = host_ip.s_addr;
	     arg_add_value(arglist, "hostip", ARG_PTR, -1, ia); 
	     if(MAC) arg_add_value(arglist, "host_mac_addr", ARG_STRING, -1, MAC);
	     
             arg_add_value(arglist, "plugins", ARG_ARGLIST, -1, plugins);
             arg_add_value(arglist, "port_range", ARG_STRING, -1, port_range);
             arg_add_value(arglist, "hosts_list", ARG_ARGLIST, -1, hosts_list); 
	     arg_add_value(arglist, "atoms", ARG_PTR, -1, atoms);
	     
	     pid = create_thread((void*)attack_start, arglist, (struct arglist*)-1); 
	     nessusd_thread_register(threads, MAC ? MAC : hostname, pid);
	     if(s[0] >= 0)
	  	   attack_atom_insert(atoms, MAC ? MAC : hostname, s[1], s[0]);
             num_threads++;
	     log_write("user %s : testing %s [%d]\n", attack_user_name(globals), hostname, pid);
	     arg_free(arglist);
	     efree(&MAC);
	     efree(&ia);
	    }
	  else 
	    {
              /* 
               * There are too many threads at this time... We
               * have to wait until one of them finishes
               */
	      host_pending = 1; /* means that we must NOT update the hostname */
             
	      while(num_threads >= max_hosts)
                {
		 int e;
		/*
		 * Check the threads input
		 */
		if((e = check_threads_input(atoms, detached ? -1 : global_socket, globals))<0)
			{
			if(e == -1)
			{
			 nessusd_thread_kill_all(threads);
			 return_code = -1;
			}
			goto stop;		
			}
		num_threads = wait_for_a_thread(threads);
                }
	    }
	} else {
		log_write("user %s : rejected attempt to scan %s", 
			attack_user_name(globals), hostname);
		  arg_add_value(rejected_hosts, hostname, ARG_INT, sizeof(int), (void*)1);	
		}	
      if(!host_pending)
      {
        num_tested++;
	efree(&hostname);
       	hostname = hg_next_host(hg_globals, &host_ip);
	if(tested)
	 while(hostname &&
	       harg_get_int(tested, hostname))
		{
		efree(&hostname);
		hostname = hg_next_host(hg_globals, &host_ip);
		}
	
      }
     }
 
   
    
 
  /*
   * Every host is being tested... We have to wait for the threads
   * to terminate
   */
  
  
  while(wait_for_a_thread(threads)){
	/*
	 * check threads input
	 */
	int n = check_threads_input(atoms, detached ? -1 : global_socket, globals);
	while(n)
	 {
	 n = check_threads_input(atoms, detached ? -1 : global_socket, globals);
	 if(n < 0)
	  {
	  if(n == -1)
	  {
	  nessusd_thread_kill_all(threads);
	  return_code = -1;
	  }
	  goto stop;
	  }
	 wait_for_a_thread(threads);
	 }  
        }
  
   data = check_threads_input(atoms, detached ? -1 : global_socket, globals);
   if(data < 0)
    {
    if(data == -1)
    {
    nessusd_thread_kill_all(threads);
    return_code = -1;
    }
    goto stop;
    }
    
   while(data>0)
    {
    data = check_threads_input(atoms, detached ? -1 : global_socket, globals);
    if(data < 0)
     {
     if(data == -1)
     {
     nessusd_thread_kill_all(threads);
     return_code = -1;
     }
     goto stop;
     }
    } 
      
    
    
    
   /*
    * some_function(hosts_arglist_to_string(tested_hosts));
    */
    
   log_write("user %s : test complete", attack_user_name(globals));
   
    /*
     * Delete the files uploaded by the user, if any
     */
    files = arg_get_value(globals, "files_translation");
    if(files)
    {
     hw  = harg_walk_init(files);
     while((key = (char*)harg_walk_next(hw)))
      {
      unlink(harg_get_string(files, key));
      }
    }
  }
 
  if(rejected_hosts && rejected_hosts->next)
   {
     char * banner = emalloc(4001);
     int length = 0;

     sprintf(banner, "SERVER <|> ERROR <|> These hosts could not be tested because you are not allowed to do so :;");
     length = strlen(banner);

     while(rejected_hosts->next && (length < (4000-3)))
	{
	  int n;
	  n = strlen(rejected_hosts->name);
	  if(length + n + 1 >= 4000)
	  {
	    n = 4000 - length  - 2;
	  }
	  strncat(banner, rejected_hosts->name, n);
	  strncat(banner, ";", 1);
	  length+=n+1;
	  rejected_hosts = rejected_hosts->next;
	}
      if(rejected_hosts->next)
       strcat(banner, "...");
       
     auth_printf(globals, "%s\n", banner);
   }
	
stop:
  if(save_session){
  	save_tests_close(globals);
	if(!preferences_save_empty_sessions(preferences))
	{
	 if(save_tests_empty(globals))
          {
            log_write("user %s : Nothing interesting found - deleting the session\n",
    		(char*)arg_get_value(globals, "user"));
             save_tests_delete_current(globals);
	  }
        }
   }
  
  hg_cleanup(hg_globals);
  ports = arg_get_value(globals, "ports");
  efree(&ports);
  efree(&port_range);
  
  arg_free_all(hosts_list);
  
  nessusd_threads_free(threads);
  Threads = NULL;
  attack_atom_free(atoms);
  arg_free_all(rejected_hosts);
  if(detached)
  {
   if(preferences_detached_scan_email(preferences))
    detached_send_email(globals);
  }
  
  if(continuous){
  	sleep(preferences_delay_between_scans(preferences));
	plugins = plugins_reload(preferences, plugins);
	arg_set_value(globals, "plugins", -1, plugins);
  	goto start_attack_network;
	}
  else if(detached)detached_end_session(globals);	
  
  return return_code;
}

   
 
