/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <includes.h>
#include "report.h"
#include "error_dialog.h"
#include "backend.h"
#include "data_mining.h"
#include "report_utils.h"

int backend_to_nbe(int, char *);
int nbe_to_backend(char*);



/*------------------------- Private functions ------------------------------*/

int 
nbe_to_backend(filename)
 char * filename;
{
 int fd = open(filename, O_RDONLY);
 int be = backend_init(NULL);
 int befd = backend_fd(be);
 off_t tot = 0;
 char buf[4096];
 struct stat stat;
 
 lseek(fd, 0, SEEK_SET);
 fstat(fd, &stat);
 while(tot < stat.st_size)
 {
  int e;
  bzero(buf, sizeof(buf));
  e = read(fd, buf, sizeof(buf));
  if(e < 0)
   {
    perror("read ");
    return -1;
   }
  write(befd, buf, e);
  tot+=e;
 }
 close(fd);
 return be; 
}




/*
 * XXXX
 *
 * Does not handle the case where the backend is not
 * a file
 */
int 
backend_to_nbe(be, filename)
 int be;
 char * filename;
{
 int fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0600);
 int befd = backend_fd(be);
 off_t tot = 0;
 char buf[4096];
 struct stat stat;
 
 lseek(befd, 0, SEEK_SET);
 fstat(befd, &stat);
 while(tot < stat.st_size)
 {
  int e;
  bzero(buf, sizeof(buf));
  e = read(befd, buf, sizeof(buf));
  if(e < 0)
   {
    perror("read ");
    return -1;
   }
  write(fd, buf, e);
  tot+=e;
 }

 close(fd);
 return 0; 
}

