/* Nessus
 * Copyright (C) 1999 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * plugs_deps : plugins dependencies.
 *
 */
#include <includes.h>
#include "log.h"
#include "rtree.h"

static struct arglist *
deps_plugin(plugin)
 struct arglist * plugin;
{
 struct arglist *t = NULL;
 struct arglist * deps = NULL;
 
 if((t  = arg_get_value(plugin, "plugin_args")))
   deps = (void *)arg_get_value(t, "DEPENDENCIES");
 
 return(deps);
}

static int
dep_plugin_type(plugin)
 struct arglist * plugin;
{
 struct arglist * t = arg_get_value(plugin, "plugin_args");
 return (int)arg_get_value(t, "CATEGORY");
}

static void
dep_plugin_set_type(plugin, newtype)
 struct arglist * plugin;
 int newtype;
{
 struct arglist * t = arg_get_value(plugin, "plugin_args");
 arg_set_value(t, "CATEGORY", sizeof(int), (void*)newtype);
}


/*
 * Search for <name> on the current level of the tree
 */
static struct rtree *
deps_rtree_find_node_by_name(tree, name)
 struct rtree * tree;
 char * name;
{
 int i, l;
 
 l = rtree_node_num_elems(tree);
 for(i=0; i < l; i++)
 {
  struct rtree * node = rtree_node_get_nth_node(tree, i);
  struct arglist * plugin = node ? rtree_node_data(node):NULL;
  if(plugin && !strcmp(plugin->name, name))
   return node;
 }
 return NULL; 
}

static struct rtree * 
deps_plugins_sort_bynode(node, moved_up, autoload)
 struct rtree * node;
 struct arglist * moved_up;
 int autoload;
{
 struct arglist * plugin = rtree_node_data(node);
 if(plugin)
 {
  struct arglist * deps = deps_plugin(plugin->value);
  if(deps)
  {
   while(deps->next)
   {
    if(!arg_get_value(moved_up, deps->name))
    {
     struct rtree * dep = deps_rtree_find_node_by_name(node->root, deps->name);
     if(dep)
     {
      struct arglist * data = rtree_node_data(dep);
      int cat1, cat2;
      
      /*
       * Change the category of the plugin if it's needed
       * by an earlier category
       */
      if(data)
      {
       cat1 = dep_plugin_type(data->value);
       cat2 = dep_plugin_type(plugin->value);
       if(cat1 > cat2)
	   dep_plugin_set_type(data->value, cat2);
      }
      
      if(autoload)
      {
        if(plug_get_launch(plugin->value))
          plug_set_launch(data->value, 1);
      }
      
      
      if(deps_plugin(data->value))
       deps_plugins_sort_bynode(dep, moved_up, autoload);
      
      rtree_node_data_move_up(dep);
      arg_add_value(moved_up, deps->name, ARG_INT, sizeof(int), (void*)1); 
     }
    }
    deps = deps->next;
   }
  }
 }
 return 0;
}



static struct rtree *
deps_plugins_sort_level(tree, autoload)
 struct rtree * tree;
 int autoload;
{
 int i, l;
 struct arglist * moved_up = emalloc(sizeof(struct arglist));
 
 l = rtree_node_num_elems(tree);
 for(i=0;i<l;i++)
 {
  struct rtree * node = rtree_node_get_nth_node(tree, i);
  deps_plugins_sort_bynode(node, moved_up, autoload);
 }
 arg_free_all(moved_up);
}


#if 1
void simul(tree)
 struct rtree * tree;
{
 int i, l;
 struct arglist * plugin = rtree_node_data(tree);
 printf("----- plugins to launch at the same time ------\n");
 
 if(plugin)
 {
  printf("%s\n", plugin->name);
 }
 l = rtree_node_num_elems(tree);
 for(i=0;i<l;i=i+1)
 {
  struct rtree * node = rtree_node_get_nth_node(tree, i);
  struct arglist * plugin = node ? rtree_node_data(node):NULL;
  if(plugin)printf("%s\n", plugin->name);
 }
 
 if(l)
  simul(rtree_node_get_nth_node(tree, 0));
}
#endif


/*
 * Sorts our plugins by dependencie. This is _far_ from being
 * a correct method, as the most depended plugin end on top
 * of everything. However, it's simple to implement and bugfree,
 * so I'll keep that solution for now
 */
struct rtree * 
deps_plugins_sort(plugins, autoload)
 struct arglist * plugins;
 int autoload;
{
 struct rtree * root = rtree_node_new(NULL, 1000);
 struct rtree * t;
 
 /*
  * Put our arglist into an rtree
  */
 if(plugins)
  while(plugins->next)
  {
   struct rtree * node = rtree_node_new_with_data(root, 0, plugins);
   if(!node)
    return NULL;
   plugins = plugins->next;
  }
 
 deps_plugins_sort_level(root, autoload);
 t = root->root;
 while(t)
 {
  deps_plugins_sort_level(t, autoload);
  t = t->root;
 }
 return(rtree_root(root));
}
 


